% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glssoln.R
\name{glssoln}
\alias{glssoln}
\title{Generalized least-squares solver}
\usage{
glssoln(a, x, v, tol = sqrt(.Machine$double.eps))
}
\value{
\code{glssoln} returns a list of two named components:
\itemize{
\item \code{coeff} is \eqn{y} as above.
\item \code{residuals} is \eqn{e} as above.
}
}
\description{
Solves the generalized least squares problem.
}
\details{
Given matrices \eqn{a}, \eqn{x}, \eqn{v}, \code{glssoln} computes \eqn{y} such that
\deqn{(x-ay)^T v^{-1} (x-ay)}
is minimized.
This is accomplished by first computing the Choleski decomposition of \eqn{v}:
\deqn{v=LL^T.}
One then solves for \eqn{y} in the equation
\deqn{L^{-1}ay=L^{-1}x.}
This is accomplished by means of a singular-value decomposition of \eqn{L^{-1} a}.

The resulting \eqn{y} then satisfies
\deqn{x=ay+e,}
where the entries of \eqn{e} are the residuals.
}
\keyword{internal}
