library(otsad)
context("Optimized Incremental Processing Sd-Ewma")

test_that("OipSdEwma gives the correct result", {
  ## Generate data
  set.seed(100)
  n <- 500
  # x <- sample(1:100, n, replace = TRUE)
  # x[70:90] <- sample(110:115, 21, replace = TRUE)
  # x[25] <- 200
  # x[320] <- 170
  x <- c(31,26,56,6,47,49,82,38,55,18,63,89,29,40,77,67,21,36,36,70,54,72,54,75,200,18,78,89,55,28,
         49,93,35,96,70,89,19,63,99,14,34,87,78,83,61,50,79,89,21,31,34,20,24,28,60,26,13,23,60,22,
         47,65,97,68,45,36,46,45,25,111,114,111,112,112,112,114,111,114,113,111,112,110,112,115,110,
         110,112,111,115,113,91,21,36,45,91,39,52,13,4,78,33,39,5,37,58,69,98,71,2,54,84,81,9,24,
         97,4,92,73,21,85,40,40,48,59,36,3,100,96,56,11,24,87,74,50,58,2,48,5,47,63,68,9,15,91,13,
         73,96,5,2,20,51,93,14,17,61,82,85,79,2,70,82,57,49,17,9,17,3,71,77,86,44,42,59,83,80,33,96,
         66,46,61,29,72,93,68,19,35,13,11,30,84,100,44,21,97,67,30,12,60,13,79,37,96,92,83,32,88,81,
         62,8,43,35,76,22,30,36,64,90,75,46,4,57,44,61,96,27,66,8,8,38,30,56,37,85,63,40,30,39,71,
         95,78,22,72,67,71,28,72,67,5,7,28,31,96,39,38,85,85,32,14,62,80,34,91,20,80,76,92,33,9,92,
         96,68,75,45,12,68,74,49,18,68,27,35,22,2,38,57,68,75,96,17,33,14,64,34,65,31,8,67,76,56,
         54,85,66,96,62,50,98,50,66,60,95,37,88,46,50,47,62,61,79,56,170,41,52,53,100,43,100,79,52,
         51,92,27,18,41,54,25,38,59,21,81,64,74,44,58,26,47,17,62,96,48,76,3,18,64,17,36,19,90,24,
         99,3,11,25,73,4,55,69,31,39,74,97,77,59,47,36,39,21,14,39,27,71,41,27,41,20,83,53,40,58,98,
         66,34,34,95,39,57,52,14,24,72,30,52,28,37,44,81,53,70,85,85,40,16,64,29,93,16,97,1,71,64,
         78,90,52,75,93,10,50,20,100,4,22,90,12,37,17,17,98,82,96,40,86,7,31,50,65,52,80,57,36,66,
         24,27,52,74,78,12,62,92,64,28,36,68,91,74,92,39,86,6,26,37,37,29,39,35,28,81,100,76,61,60,
         59,24,46,100,9,6,50,6,96,64,27,100,36,38,34,11,58,34,1,100,37)
  df <- data.frame(timestamp=1:n,value=x)

  ## Initialize parameters for the loop
  last.res <- NULL
  res <- NULL
  nread <- 250
  numIter <- n%/%nread
  iterador <- 0

  ## Calculate anomalies
  for(i in 1:numIter) {
    # read new data
    newRow <- df[(iterador+1):(iterador+nread),]
    # calculate if it's an anomaly
    last.res <- OipSdEwma(
      data = newRow$value,
      n.train = 5,
      threshold = 0.01,
      l = 3,
      last.res = last.res$last.res
    )
    # prepare the result
    if(!is.null(last.res$result)){
      res <- rbind(res, cbind(newRow, last.res$result))
    }
    iterador <- iterador + nread
  }

  ## read correct results
  correct.results <- rep(0, 500)
  correct.results[c(25,92,320)] <- 1

  expect_equal(as.numeric(res$is.anomaly), correct.results)

})
