% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-attributes.R
\name{as_attributes}
\alias{as_attributes}
\title{R objects as OpenTelemetry attributes}
\usage{
as_attributes(x)
}
\arguments{
\item{x}{A list of R objects, to be used as OpenTelemetry attributes.}
}
\value{
A named list that can be used as the \code{attributes} argument to
the \code{start_span()} method of \link{otel_tracer}, the \code{log()} method of
\link{otel_logger}, etc.

If \code{x} is not named, or some names are the empty string or \code{NA}, then
integer numbers as used for the missing or invalid names.

If some elements in \code{x} are not of the natively supported R types in
OpenTelemetry (character, logical, double, integer), then
their printed form is captured using \code{\link[utils:capture.output]{utils::capture.output()}}.
\subsection{Limits}{

The number of attributes can be limited with the
OTEL_ATTRIBUTE_VALUE_LENGTH_LIMIT environment variable. The default is
128.

The length of the each attribute (vector) can be limited with the
OTEL_ATTRIBUTE_VALUE_LENGTH_LIMIT environment variable. The default is
\code{Inf}. Note that this is applied to
the length of each attribute as an R vector. E.g. it does \emph{not}
currently limit the number of characters in individual strings.
}
}
\description{
Convert a list of R objects to a form that is suitable as OpenTelemetry
attributes.
}
\examples{
as_attributes(list(
  number = 1.0,
  vector = 1:10,
  string = "otel",
  string_vector = letters,
  object = mtcars
))
}
