% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmIsochrone.R
\name{osrmIsometric}
\alias{osrmIsometric}
\title{Get Polygons of Isodistances}
\usage{
osrmIsometric(
  loc,
  breaks = seq(from = 0, to = 10000, length.out = 4),
  exclude = NULL,
  res = 30,
  returnclass = "sp",
  osrm.server = getOption("osrm.server"),
  osrm.profile = getOption("osrm.profile")
)
}
\arguments{
\item{loc}{a numeric vector of longitude and latitude (WGS84), an sf object, 
a SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the origine point.}

\item{breaks}{a numeric vector of isometric values (in meters).}

\item{exclude}{pass an optional "exclude" request option to the OSRM API.}

\item{res}{number of points used to compute isochrones, one side of the square 
grid, the total number of points will be res*res.}

\item{returnclass}{class of the returned polygons. Either "sp" of "sf".}

\item{osrm.server}{the base URL of the routing server.
getOption("osrm.server") by default.}

\item{osrm.profile}{the routing profile to use, e.g. "car", "bike" or "foot"
(when using the routing.openstreetmap.de test server).
getOption("osrm.profile") by default.}
}
\value{
A SpatialPolygonsDateFrame or an sf MULTIPOLYGON of isochrones is returned. 
The data frame of the output contains four fields: 
id (id of each polygon), min and max (minimum and maximum breaks of the polygon), 
center (central values of classes).
}
\description{
Based on \code{\link{osrmTable}}, this function buids polygons 
 of isometric road distances.
}
\examples{
\dontrun{
library(sf)
data("berlin")
# Get isochones with lon/lat coordinates
iso <- osrmIsometric(loc = c(13.43,52.47), breaks = c(0,100,200, 500, 1000),
                     returnclass="sf")
plot(st_geometry(iso))
}
}
\seealso{
\link{osrmTable}
}
