% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_install.R
\name{osrm_check_available_versions}
\alias{osrm_check_available_versions}
\title{Check for Available OSRM Versions}
\usage{
osrm_check_available_versions(prereleases = FALSE)
}
\arguments{
\item{prereleases}{A logical value. If \code{TRUE}, include pre-release versions
in the returned list. Defaults to \code{FALSE}.}
}
\value{
A character vector of available version tags.
}
\description{
Queries the GitHub API to get a list of all available version tags for the
OSRM backend that have binaries for the current platform.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  # Get all stable versions with binaries for this platform
  osrm_check_available_versions()
}
}
}
