% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add-colourbar.R
\name{add_colourbar}
\alias{add_colourbar}
\title{add_colorbar}
\usage{
add_colourbar(len = c(0.1, 0.9), width = 0.02, side = 1, cols = NULL,
  zlims = c(0, 1), transp = 0.4, tcol = "black", ps = 8)
}
\arguments{
\item{len}{Relative positions of start and end of colourbar}

\item{width}{Relative width}

\item{side}{(1,2,3,4) for colourbar (below, left, above, right) of map. (Not
yet implemented.)}

\item{cols}{Vector of colours}

\item{zlims}{Vector of (min,max) values for scale of colourbar. These should
be the values returned from add_osm_surface ().}

\item{transp}{Transparency level of region immediately surrounding colourbar,
including behind text. Lower values are more transparent.}

\item{tcol}{Colour of text, tick marks, and lines on colourbar}

\item{ps}{PointSize of text labels}
}
\description{
Adds a colourbar to an existing map. Intended to be used in combination with
add_osm_surface (). At present, only plots on right side of map.
}
\examples{
plot_osm_basemap (bbox=get_bbox (c (-0.15, 51.5, -0.1, 51.52)), col="gray20")
add_osm_objects (london$dat_BNR, col="gray40") # non-residential buildings
add_axes ()
add_colourbar (cols=heat.colors(20), tcol="white", side=4)
}

