% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose.config-class.R, R/osmose.config-plot.R
\name{plot.osmose.config}
\alias{plot.osmose.config}
\alias{plot.osmose.config.reproduction}
\alias{plot.osmose.config.species}
\alias{plot.osmose.config.predation}
\title{Plot method for \code{osmose.config} objects}
\usage{
\method{plot}{osmose.config}(x, what = "predation", ...)

\method{plot}{osmose.config.reproduction}(
  x,
  type = 1,
  species = 0,
  speciesNames = NULL,
  start = NULL,
  end = NULL,
  initialYear = NULL,
  freq = 12,
  xlim = NULL,
  ylim = NULL,
  col = "black",
  axes = TRUE,
  border = NA,
  legend = TRUE,
  ...
)

\method{plot}{osmose.config.species}(
  x,
  n = 100,
  type = 1,
  species = 0,
  speciesNames = NULL,
  addElements = c("segments", "points", "polygon", "text"),
  axes = TRUE,
  border = NA,
  xlim = NULL,
  ylim = NULL,
  legend = TRUE,
  col = "black",
  ...
)

\method{plot}{osmose.config.predation}(
  x,
  type = 1,
  species = 0,
  speciesNames = NULL,
  addElements = c("segments", "points", "text"),
  axes = TRUE,
  border = NA,
  xlim = NULL,
  ylim = NULL,
  col = "gray70",
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{osmose} like object.}

\item{what}{Variable name to plot. By default is \code{what = "predation"}. 
See Details.}

\item{...}{Extra arguments of the function.}

\item{type}{A \code{numeric} value, indicating the type of plot to be used 
(\code{type = 1}, by default). See Details.}

\item{species}{A \code{numeric} vector specifying the species that will be 
showed. If \code{NULL} (default), all the available species time series will 
be plotted. See Details.}

\item{speciesNames}{A vector with the names for each species. If \code{NULL}
(default) the names of \code{x} will be used.}

\item{start}{A \code{numeric} value indicating the first element of the time 
indexation of the object \code{x} is specified with this parameter. By 
default \code{start = NULL} and the time indexation start with the first 
element of \code{x}.}

\item{end}{A \code{numeric} value. The last element of the time indexation of
the object \code{x} is specified with this parameter. By default 
\code{end = NULL} and the time indexation finish with the last element of 
\code{x}.}

\item{initialYear}{A \code{numeric} value. It specifies the first element 
that is going to be used on the x axis for the plots.}

\item{freq}{A \code{numeric} value to indicate the steps by year used in the 
time series. Default values, see Details.}

\item{xlim, ylim}{numeric vectors of length 2, giving the x and y coordinates 
ranges.}

\item{col}{A vector with the color names for the plots. By default 
\code{col = NULL} and the colors will be chosen by the function.}

\item{axes}{a \code{logical} value indicating whether both axes should be 
drawn on the plot.}

\item{border}{the color to draw the border of CI polygons, bar plots and 
box plots. By default, \code{border = NA}, which means that no border will be 
drawn.}

\item{legend}{\code{logical} do you want to show a legend of species? (valid
only for those plot types TS-2)}

\item{n}{\code{numeric} value indicating the number of steps that are going
to be used to plot the growth curve (\code{n = 100} as default). The larger
is n, the more resolution the curve will have.}

\item{addElements}{A \code{character} vector indicating extra graphical 
elements that can be included.}
}
\description{
This method takes a \code{osmose.config} object and produce 
useful plots.

This function implements a plot method for different osmose 
classes.
}
\details{
Plot types will depend on the class of \code{x}, which is defined
by \code{what}. Thereby,
\itemize{
\item{\code{what = predation}: }{Generates a plot of size range as shadows
for a selected species .}
 \item{\code{what = reproduction}: }{Generates a single plots of seasonality 
 of reproduction whether as lines (\code{type = 1}) or bars (\code{type = 2})}
 \item{\code{what = species}: }{Generates a plot of growth curve following the
 VB parameters defined on configuration files (\code{type = 1}).}
}

\code{species} argument follows the indexation way of java: starting in zero,
as osmose-java returns species outputs.

Default value for \code{freq} will be calculated from \code{x}: 
\eqn{freq = 1/x$model$start}.

Extra arguments can be passed using \code{...} and depending on the type, you
can modify arguments like: \code{cex},  \code{cex.axis}, \code{border} 
(useful for \code{polygon} and \code{barplot}s), etc.
}
\note{
Ellipsis (\code{...}) must be used carefully, since it will pass the
arguments to different generic plot functions. For instance, \code{type = 2} 
of \code{osmose.config.reproduction} method will use \code{...} to pass 
arguments to \link{barplot}, so some arguments like \code{cex} may match with 
many formal arguments (e.g. \code{cex.axis} and \code{cex.names}), so it may 
cause errors.
}
\author{
Criscely Lujan Paredes
}
