/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.grid;

import fr.ird.osmose.Cell;
import fr.ird.osmose.grid.AbstractGrid;
import java.io.IOException;
import ucar.nc2.NetcdfFile;

public class NcGrid
extends AbstractGrid {
    private String gridFile;
    private String strLon;
    private String strLat;
    private String strMask;

    @Override
    void readParameters() {
        this.gridFile = this.getConfiguration().getFile("grid.netcdf.file");
        this.strLat = this.getConfiguration().getString("grid.var.lat");
        this.strLon = this.getConfiguration().getString("grid.var.lon");
        this.strMask = this.getConfiguration().getString("grid.var.mask");
    }

    @Override
    Cell[][] makeGrid() {
        NetcdfFile ncGrid = this.openNetcdfFile(this.gridFile);
        double[][] lon = this.readVariable(ncGrid, this.strLon);
        double[][] lat = this.readVariable(ncGrid, this.strLat);
        double[][] mask = this.readVariable(ncGrid, this.strMask);
        int ny = lon.length;
        int nx = lon[0].length;
        Cell[][] grid = new Cell[ny][nx];
        for (int j = 0; j < ny; ++j) {
            for (int i = 0; i < nx; ++i) {
                boolean land = mask[j][i] <= 0.0;
                grid[j][i] = new Cell(j * nx + i, i, j, (float)lat[j][i], (float)lon[j][i], land);
            }
        }
        return grid;
    }

    private NetcdfFile openNetcdfFile(String gridFile) {
        try {
            return NetcdfFile.open(gridFile, null);
        }
        catch (IOException ex) {
            this.error("Failed to open NetCDF grid file " + gridFile, ex);
            return null;
        }
    }

    private double[][] readVariable(NetcdfFile nc, String varname) {
        try {
            return (double[][])nc.findVariable(varname).read().copyToNDJavaArray();
        }
        catch (IOException ex) {
            this.error("Error while reading variable " + varname + " in NetCDF grid file " + nc.getLocation(), ex);
            return null;
        }
    }
}

