% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapiR_connection.R
\name{set_osmapi_connection}
\alias{set_osmapi_connection}
\alias{get_osmapi_url}
\alias{set_osmapi_url}
\title{Configure connections from osmapiR}
\usage{
set_osmapi_connection(
  server = c("openstreetmap.org", "testing"),
  cache_authentication
)

get_osmapi_url()

set_osmapi_url(osmapi_url)
}
\arguments{
\item{server}{If \code{openstreetmap.org} (default), the API calls will be performed to the servers in production. If
\code{testing}, the calls will be against \url{https://master.apis.dev.openstreetmap.org} without affecting the main OSM
data.}

\item{cache_authentication}{If \code{TRUE}, the authentication token will be cached on disk. This reduces the number of
times that you need to re-authenticate at the cost of storing access credentials on disk. Cached tokens are
encrypted and automatically deleted 30 days after creation. If missing (default), no changes will be applied. On
package load time, the option is set to \code{FALSE} if it's not yet set.}

\item{osmapi_url}{The desired API URL to send the calls.}
}
\value{
Configure \code{.Options[grep("^osmapir\\\\.[a-z]+_(?!secret$)", names(.Options), perl = TRUE)]} :) and return
\code{osmapir.base_api_url}.
}
\description{
Functions to configure the connections. Probably, you should only use \code{set_osmapi_connection}.
}
\details{
When testing your software against the API you should consider using \url{https://master.apis.dev.openstreetmap.org}
instead of the live-api (\code{set_osmapi_connection("testing")}). Your account for the live service is not in the same
database, so you probably need a new username and password for the test service; please visit that page in a browser
to sign up.

\code{set_osmapi_url()} and \code{get_osmapi_url} only deal with the API base URL. On the other hand, \code{set_osmapi_connection}
also configure the authentication parameters needed for \code{PUT}, \code{POST} and \code{DELETE} calls.

For further details, see \url{https://wiki.openstreetmap.org/wiki/API_v0.6}.
}
\examples{
ori <- get_osmapi_url()
set_osmapi_connection(server = "testing")
get_osmapi_url()
set_osmapi_connection(server = "openstreetmap.org")
get_osmapi_url()

## Restore options
if (ori == "https://api.openstreetmap.org") {
  set_osmapi_connection(server = "openstreetmap.org")
} else if (ori == "https://master.apis.dev.openstreetmap.org") {
  set_osmapi_connection(server = "testing")
} else {
  warning(
    "A non standard osmapiR connection detected (", ori,
    "). If you configured manually options like \"osmapir.base_api_url\" or \"osmapir.oauth_id\", ",
    "configure it again."
  )
}
}
\seealso{
Other API functions: 
\code{\link{authenticate_osmapi}()},
\code{\link{osm_api_versions}()},
\code{\link{osm_capabilities}()},
\code{\link{osm_permissions}()}
}
\concept{API functions}
