# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title General solver \code{C++} function
#' @name gen_solver
#' @description A general purpose optimization solver with orthogonality constraint. For details, please see the original \code{MATLAB} code by Wen and Yin (2013). This is an internal function and should not be called directly.
#' @keywords internal
#' @param B A matrix of the parameters \code{B}, the columns are subject to the orthogonality constraint
#' @param f A function that calculates the objective function value. The first argument should be \code{B}. Returns a single value.
#' @param g A function that calculates the gradient. The first argument should be \code{B}. Returns a matrix with the same dimension as \code{B}. If not specified, then the numerical approximation is used.
#' @param env Environment passed to the Rcpp function for evaluating \code{f} and \code{g}
#' @param useg If true, the gradient is calculated using \code{g} function, otherwise numerically approximated
#' @param rho (don't change) Parameter for control the linear approximation in line search
#' @param eta (don't change) Factor for decreasing the step size in the backtracking line search
#' @param gamma (don't change) Parameter for updating C by Zhang and Hager (2004)
#' @param tau (don't change) Step size for updating
#' @param epsilon (don't change) Parameter for approximating numerical gradient, if \code{g} is not given.
#' @param btol (don't change) The \code{$B$} parameter tolerance level
#' @param ftol (don't change) Functional value tolerance level
#' @param gtol (don't change) Gradient tolerance level
#' @param maxitr Maximum number of iterations
#' @param verbose Should information be displayed
#' @references Wen, Z. and Yin, W., "A feasible method for optimization with orthogonality constraints." Mathematical Programming 142.1-2 (2013): 397-434. DOI: \url{https://doi.org/10.1007/s10107-012-0584-1}
#' @references Zhang, H. and Hager, W. W., "A nonmonotone line search technique and its application to unconstrained optimization." SIAM J. Optim. 14 (2004): 1043–1056. DOI: \url{https://doi.org/10.1007/s10107-012-0584-1}
#' @examples
#' # This function should be called internally. When having all objects pre-computed, one can call
#' # gen_solver(B, f, g, env, useg, rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
#' # to solve for the parameters B.
gen_solver <- function(B, f, g, env, useg, rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose) {
    .Call('_orthoDr_gen_solver', PACKAGE = 'orthoDr', B, f, g, env, useg, rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
}

#' @title surv_solver
#' @name surv_solver
#' @description The main optimization function for survival dimensional reduction, the IR-CP method. This is an internal function and should not be called directly.
#' @keywords internal
#' @param B A matrix of the parameters \code{B}, the columns are subject to the orthogonality constraint
#' @param X The covariate matrix
#' @param Phit Phit as defined in Sun et al. (2017)
#' @param inRisk A matrix of indicators shows whether each subject is still alive at each time point
#' @param bw A Kernel bandwidth, assuming each variable have unit variance
#' @param Fail_Ind The locations of the failure subjects
#' @param rho (don't change) Parameter for control the linear approximation in line search
#' @param eta (don't change) Factor for decreasing the step size in the backtracking line search
#' @param gamma (don't change) Parameter for updating C by Zhang and Hager (2004)
#' @param tau (don't change) Step size for updating
#' @param epsilon (don't change) Parameter for approximating numerical gradient
#' @param btol (don't change) The \code{$B$} parameter tolerance level
#' @param ftol (don't change) Estimation equation 2-norm tolerance level
#' @param gtol (don't change) Gradient tolerance level
#' @param maxitr Maximum number of iterations
#' @param verbose Should information be displayed
#' @return The optimizer \code{B} for the esitmating equation.
#' @references Sun, Q., Zhu, R., Wang T. and Zeng D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017) \url{https://arxiv.org/abs/1704.05046} .
#' @references Wen, Z. and Yin, W., "A feasible method for optimization with orthogonality constraints." Mathematical Programming 142.1-2 (2013): 397-434. DOI: \url{https://doi.org/10.1007/s10107-012-0584-1}
#' @examples
#' # This function should be called internally. When having all objects pre-computed, one can call
#' # surv_solver(B, X, Phit, inRisk, bw, Fail.Ind,
#' #             rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
#' # to solve for the parameters B.
#'
surv_solver <- function(B, X, Phit, inRisk, bw, Fail_Ind, rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose) {
    .Call('_orthoDr_surv_solver', PACKAGE = 'orthoDr', B, X, Phit, inRisk, bw, Fail_Ind, rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
}

