% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{ore_search}
\alias{ore_search}
\alias{orematch}
\alias{orematches}
\alias{ore.search}
\alias{ore_match}
\alias{ore.match}
\alias{is_orematch}
\alias{is.orematch}
\alias{[.orematch}
\alias{[.orematches}
\alias{print.orematch}
\alias{print.orematches}
\title{Search for matches to a regular expression}
\usage{
ore_search(regex, text, all = FALSE, start = 1L, simplify = TRUE,
  incremental = !all)

is_orematch(x)

\method{[}{orematch}(x, j, k, ...)

\method{[}{orematches}(x, i, j, k, ...)

\method{print}{orematch}(x, lines = getOption("ore.lines", 0L),
  context = getOption("ore.context", 30L), width = getOption("width", 80L),
  ...)

\method{print}{orematches}(x, lines = getOption("ore.lines", 0L), simplify = TRUE, ...)
}
\arguments{
\item{regex}{A single character string or object of class \code{"ore"}. In
the former case, this will first be passed through \code{\link{ore}}.}

\item{text}{A vector of strings to match against, or the result of a call to
\code{\link{ore_file}} to search in a file. In the latter case, match
offsets will be relative to the file's encoding.}

\item{all}{If \code{TRUE}, then all matches within each element of
\code{text} will be found. Otherwise, the search will stop at the first
match.}

\item{start}{An optional vector of offsets (in characters) at which to start
searching. Will be recycled to the length of \code{text}.}

\item{simplify}{If \code{TRUE}, an object of class \code{"orematch"} will
be returned if \code{text} is of length 1. Otherwise, a list of such
objects, with class \code{"orematches"}, will always be returned. When
printing \code{"orematches"} objects, this controls whether or not to omit
nonmatching elements from the output.}

\item{incremental}{If \code{TRUE} and the \code{text} argument points to a
file, the file is read in increasingly large blocks. This can reduce
search time in large files.}

\item{x}{An R object.}

\item{j}{For indexing, the match number.}

\item{k}{For indexing, the group number.}

\item{...}{Ignored.}

\item{i}{For indexing into an \code{"orematches"} object only, the string
number.}

\item{lines}{The maximum number of lines to print. The default is zero,
meaning no limit. For \code{"orematches"} objects this is split evenly
between the elements printed.}

\item{context}{The number of characters of context to include either side
of each match.}

\item{width}{The number of characters in each line of printed output.}
}
\value{
For \code{ore_search}, an \code{"orematch"} object, or a list of
  the same, each with elements
  \describe{
    \item{text}{A copy of the \code{text} element for the current match.}
    \item{nMatches}{The number of matches found.}
    \item{offsets}{The offsets (in characters) of each match.}
    \item{byteOffsets}{The offsets (in bytes) of each match.}
    \item{lengths}{The lengths (in characters) of each match.}
    \item{byteLengths}{The lengths (in bytes) of each match.}
    \item{matches}{The matched substrings.}
    \item{groups}{Equivalent metadata for each parenthesised subgroup in
      \code{regex}, in a series of matrices. If named groups are present in
      the regex then \code{dimnames} will be set appropriately.}
  }
  For \code{is_orematch}, a logical vector indicating whether the specified
  object has class \code{"orematch"}. For extraction with one index, a
  vector of matched substrings. For extraction with two indices, a vector
  or matrix of substrings corresponding to captured groups.
}
\description{
Search a character vector for one or more matches to an Oniguruma-compatible
regular expression. The result is of class \code{"orematches"}, for which
printing and indexing methods are available.
}
\note{
Only named *or* unnamed groups will currently be captured, not both. If
there are named groups in the pattern, then unnamed groups will be ignored.

By default the \code{print} method uses the \code{crayon} package (if it is
available) to determine whether or not the R terminal supports colour.
Alternatively, colour printing may be forced or disabled by setting the
\code{"ore.colour"} (or \code{"ore.color"}) option to a logical value.
}
\examples{
# Pick out pairs of consecutive word characters
match <- ore_search("(\\\\w)(\\\\w)", "This is a test", all=TRUE)

# Find the second matched substring ("is", from "This")
match[2]

# Find the content of the second group in the second match ("s")
match[2,2]
}
\seealso{
\code{\link{ore}} for creating regex objects; \code{\link{matches}}
and \code{\link{groups}} for an alternative to indexing for extracting
matching substrings.
}
