% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{logLik.ocm}
\alias{logLik.ocm}
\title{Extract Log-likelihood for a Continuous Ordinal  Model}
\usage{
\method{logLik}{ocm}(object, ...)
}
\arguments{
\item{object}{an \code{ocm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
The log-likelihood of an \code{ocm} object. This is a number with attributes
\item{df}{estimated degrees of freedom for the fitted model \code{object}}
\item{nobs}{number of observations used in the fitted model \code{object}}
\item{class}{class of the returned object: \code{logLik.ocm}}
}
\description{
Extracts the log-likelihood for a fitted \code{ocm} object
}
\examples{
ANZ0001.ocm <- ANZ0001[ANZ0001$cycleno==0 | ANZ0001$cycleno==5,]
ANZ0001.ocm$cycleno[ANZ0001.ocm$cycleno==5] <- 1
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
logLik(fit.overall)
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\seealso{
\code{\link{ocm}}
}

