% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_expg.R
\name{order_expg}
\alias{order_expg}
\title{Random Sampling of Order Statistics from a Exponentiated G Distribution}
\usage{
order_expg(size, spec, a, k, n)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{spec}{character, represents an specific distribution. Possible values "norm", "exp","lnorm".}

\item{a}{numeric, represents the first shape parameter. Default value is 1.}

\item{k}{numeric, represents the Kth smallest value from a sample.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}
}
\description{
\code{order_eg} is used to obtain a random sample of order statistics from a Exponentiated G Distribution.
}
\examples{
library(orders)
order_expg(10,"exp",1,1,50)
order_expg(10,"norm",1,1,50)
order_expg(10,"lnorm",1,1,50)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statiscal Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
