% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{orderly_list_drafts}
\alias{orderly_list_drafts}
\alias{orderly_list_archive}
\title{List draft and archived reports}
\usage{
orderly_list_drafts(root = NULL, locate = TRUE, include_failed = FALSE)

orderly_list_archive(root = NULL, locate = TRUE)
}
\arguments{
\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{include_failed}{Logical, indicating if failed drafts should
be listed (only has an effect for \code{orderly_list_drafts} as
no failed run should make it into the archive).  A failed report
is one that lacks an \code{orderly_run.rds} file.}
}
\value{
A \code{data.frame} with columns \code{name} and
  \code{id}, containing character vectors of report names and
  versions, respectively.
}
\description{
List draft and archived reports.  This returns a data.frame with
columns \code{name} (see \code{\link{orderly_list}}) and \code{id}.
}
\examples{
# The orderly demo, with lots of potential reports:
path <- orderly::orderly_example("demo")

# Reports that _could_ be run:
orderly::orderly_list(path)

# Run a report twice:
id1 <- orderly::orderly_run("minimal", root = path)
id2 <- orderly::orderly_run("minimal", root = path)

# We can see both drafts:
orderly::orderly_list_drafts(path)

# Nothing is in the archive:
orderly::orderly_list_archive(path)

# Commit a report:
orderly::orderly_commit(id2, root = path)

# Only one draft now
orderly::orderly_list_drafts(path)

# And the second report is in the archive:
orderly::orderly_list_archive(path)
}
\seealso{
\code{\link{orderly_list}}, which lists the names of
  source reports that can be run, and \code{\link{orderly_latest}}
  which returns the id of the most recent report.
}
