% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R
\name{new_optimizer}
\alias{new_optimizer}
\title{Constructor}
\format{
An \code{optimizer} object is a list of five elements:
\itemize{
\item The \code{opt} element is the optimization function \code{opt}.
\item The \code{opt_name} element is the name of \code{opt}.
\item The \code{add} element is a named list, where each element is an additional
function argument for \code{opt}.
\item The \code{arg_names} element is a named list of the characters:
\itemize{
\item \code{f} (the name of the function input of \code{opt}),
\item \code{p} (the name of the starting parameter values input of \code{opt}),
\item \code{v} (the name of the optimal function value in the output list of
\code{opt}),
\item and \code{z} (the name of the optimal parameter vector in the output list
of \code{opt}).
}
\item The \code{out_ign} element is a character vector of element names in the
output of \code{opt} that are not saved. The elements \code{v} and \code{z}
are added automatically to \code{opt_ign}, because they are saved
separately, see the output documentation of \code{\link{optimizeR}}.
}
}
\usage{
new_optimizer(
  x = list(),
  opt = function() {
 },
  opt_name = character(),
  add = list(),
  f = character(),
  p = character(),
  v = character(),
  z = character(),
  out_ign = character()
)
}
\arguments{
\item{x}{A list.}

\item{opt}{An object of class \code{function}, a numerical optimizer.
\itemize{
\item It must have an input \code{f} for a function, which is optimized over its
first argument.
\item It must have an input \code{p} for the initial parameter values.
\item It must have a \code{...} argument for additional parameters to \code{f}.
\item The output must be a named list, including the optimal function value
(named \code{v}) and parameter vector (named \code{z}).
}}

\item{add}{A list of additional and named arguments to be passed to \code{opt}.}

\item{f}{The name of the function input of \code{opt}.}

\item{p}{The name of the starting parameter values input of \code{opt}.}

\item{v}{The name of the optimal function value in the output list of \code{opt}.}

\item{z}{The name of the optimal parameter vector in the output list of \code{opt}.}

\item{out_ign}{A character vector of element names in the output of \code{opt} that are not
saved. The elements \code{v} and \code{z} are added automatically to
\code{opt_ign}, because they are saved separately, see the output
documentation of \code{\link{optimizeR}}.}

\item{opt.name}{A character, the name of \code{opt}.}
}
\value{
An object of class \code{optimizer}.
}
\description{
This function constructs an \code{optimizer} object.
}
\details{
The \code{optimizer} object defines a numerical optimizer.
}
\keyword{internal}
