% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_locked_out_constraints.R
\name{add_locked_out_constraints}
\alias{add_locked_out_constraints}
\alias{add_locked_out_constraints,ProjectProblem,numeric-method}
\alias{add_locked_out_constraints,ProjectProblem,logical-method}
\alias{add_locked_out_constraints,ProjectProblem,character-method}
\title{Add locked out constraints}
\usage{
add_locked_out_constraints(x, locked_out)

\S4method{add_locked_out_constraints}{ProjectProblem,numeric}(x, locked_out)

\S4method{add_locked_out_constraints}{ProjectProblem,logical}(x, locked_out)

\S4method{add_locked_out_constraints}{ProjectProblem,character}(x, locked_out)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} object.}

\item{locked_out}{Object that determines which planning units that should be
locked out. See the Details section for more information.}
}
\description{
Add constraints to a project prioritization \code{\link{problem}} to ensure
that specific actions are not prioritized for funding in the solution. For
example, it may be desirable to lock out specific actions to examine their
importance to the optimal funding scheme.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# update "locked_out" column to lock out action "F2_action"
sim_actions$locked_out <- c(FALSE, TRUE, FALSE, FALSE, FALSE, FALSE)

# print action data
print(sim_actions)

# build problem with maximum richness objective and $150 budget
p1 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 150) \%>\%
     add_binary_decisions()

# print problem
print(p1)

# build another problem, and lock out the second action using numeric inputs
p2 <- p1 \%>\%
      add_locked_out_constraints(c(2))

# print problem
print(p2)

# build another problem, and lock out the actions using logical inputs
# (i.e. TRUE/FALSE values) from the sim_actions table
p3 <- p1 \%>\%
      add_locked_out_constraints(sim_actions$locked_out)

# print problem
print(p3)

# build another problem, and lock out the actions using the column name
# "locked_out" in the sim_actions table
# the sim_actions table
p4 <- p1 \%>\%
      add_locked_out_constraints("locked_out")

# print problem
print(p4)

\donttest{
# solve problems
s1 <- solve(p1)
s2 <- solve(p2)
s3 <- solve(p3)
s4 <- solve(p4)

# print the actions selected for funding in each of the solutions
print(s1[, sim_actions$name])
print(s2[, sim_actions$name])
print(s3[, sim_actions$name])
print(s4[, sim_actions$name])
}
}
