% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_plot}
\alias{wb_add_plot}
\title{Insert the current plot into a worksheet}
\usage{
wb_add_plot(
  wb,
  sheet = current_sheet(),
  width = 6,
  height = 4,
  xy = NULL,
  startRow = 1,
  startCol = 1,
  rowOffset = 0,
  colOffset = 0,
  fileType = "png",
  units = "in",
  dpi = 300,
  dims = rowcol_to_dim(startRow, startCol)
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{width}{Width of figure. Defaults to \code{6}in.}

\item{height}{Height of figure . Defaults to \code{4}in.}

\item{xy}{Alternate way to specify \code{startRow} and \code{startCol.}  A vector of
length \code{2} of form (\code{startcol}, \code{startRow})}

\item{startRow}{Row coordinate of upper left corner of figure. \code{xy[[2]]} when
\code{xy} is given.}

\item{startCol}{Column coordinate of upper left corner of figure. \code{xy[[1]]}
when \code{xy} is given.}

\item{rowOffset}{offset within cell (row)}

\item{colOffset}{offset within cell (column)}

\item{fileType}{File type of image}

\item{units}{Units of width and height. Can be \code{"in"}, \code{"cm"} or \code{"px"}}

\item{dpi}{Image resolution}

\item{dims}{Worksheet dimension, single cell ("A1") or cell range ("A1:D4")}
}
\description{
The current plot is saved to a temporary image file using
\code{\link[grDevices:dev2]{grDevices::dev.copy()}} This file is then written to the workbook using
\code{\link[=wb_add_image]{wb_add_image()}}.
}
\examples{
if (requireNamespace("ggplot2") && interactive()) {
## Create a new workbook
wb <- wb_workbook()

## Add a worksheet
wb$add_worksheet("Sheet 1", gridLines = FALSE)

## create plot objects
require(ggplot2)
p1 <- ggplot(mtcars, aes(x = mpg, fill = as.factor(gear))) +
  ggtitle("Distribution of Gas Mileage") +
  geom_density(alpha = I(.5))
p2 <- ggplot(Orange, aes(x = age, y = circumference, color = Tree)) +
  geom_point() + geom_line()

## Insert currently displayed plot to sheet 1, row 1, column 1
print(p1) # plot needs to be showing
wb$add_plot(1, width = 5, height = 3.5, fileType = "png", units = "in")

## Insert plot 2
print(p2)
wb$add_plot(1, dims = "J2", width = 16, height = 10, fileType = "png", units = "cm")

}
}
\seealso{
\code{\link[=wb_add_image]{wb_add_image()}}
}
