% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_pivot_table}
\alias{wb_add_pivot_table}
\title{Add pivot table to a worksheet}
\usage{
wb_add_pivot_table(
  wb,
  x,
  sheet = next_sheet(),
  dims = "A3",
  filter,
  rows,
  cols,
  data,
  fun,
  params
)
}
\arguments{
\item{wb}{A Workbook object containing a #' worksheet.}

\item{x}{a wb_data object}

\item{sheet}{a worksheet}

\item{dims}{the worksheet cell where the pivot table is placed}

\item{filter}{a character object with names used to filter}

\item{rows}{a character object with names used as rows}

\item{cols}{a character object with names used as cols}

\item{data}{a character object with names used as data}

\item{fun}{a character object of functions to be used with the data}

\item{params}{a list of parameters to modify pivot table creation}
}
\description{
add pivot table
}
\details{
\code{fun} can be either of \code{AVERAGE}, \code{COUNT}, \code{COUNTA}, \code{MAX}, \code{MIN},
\code{PRODUCT}, \code{STDEV}, \code{STDEVP}, \code{SUM}, \code{VAR}, \code{VARP}.

The sheet will be empty unless it is opened in spreadsheet software.
}
\examples{
wb <- wb_workbook() \%>\% wb_add_worksheet() \%>\% wb_add_data(x = mtcars)

df <- wb_data(wb)

wb <- wb \%>\%
wb_add_pivot_table(df, dims = "A3",
  filter = "am", rows = "cyl", cols = "gear", data = "disp")
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
