% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{create_dxfs_style}
\alias{create_dxfs_style}
\title{Create a custom formatting style}
\usage{
create_dxfs_style(
  font_name = NULL,
  font_size = NULL,
  font_color = NULL,
  numFmt = NULL,
  border = NULL,
  border_color = wb_color(getOption("openxlsx2.borderColor", "black")),
  border_style = getOption("openxlsx2.borderStyle", "thin"),
  bgFill = NULL,
  fgColor = NULL,
  gradientFill = NULL,
  text_bold = NULL,
  text_strike = NULL,
  text_italic = NULL,
  text_underline = NULL,
  ...
)
}
\arguments{
\item{font_name}{A name of a font. Note the font name is not validated. If fontName is NULL,
the workbook base font is used. (Defaults to Calibri)}

\item{font_size}{Font size. A numeric greater than 0.
If fontSize is NULL, the workbook base font size is used. (Defaults to 11)}

\item{font_color}{Color of text in cell.  A valid hex color beginning with "#"
or one of colors(). If fontColor is NULL, the workbook base font colors is used.
(Defaults to black)}

\item{numFmt}{Cell formatting. Some custom openxml format}

\item{border}{NULL or TRUE}

\item{border_color}{"black"}

\item{border_style}{"thin"}

\item{bgFill}{Cell background fill color.}

\item{fgColor}{Cell foreground fill color.}

\item{gradientFill}{An xml string beginning with \verb{<gradientFill>} ...}

\item{text_bold}{bold}

\item{text_strike}{strikeout}

\item{text_italic}{italic}

\item{text_underline}{underline 1, true, single or double}

\item{...}{...}
}
\value{
A dxfs style node
}
\description{
Create a new style to apply to worksheet cells. Created styles have to be
assigned to a workbook to use them
}
\details{
It is possible to override border_color and border_style with {left, right, top, bottom}_color, {left, right, top, bottom}_style.
}
\examples{
# do not apply anthing
style1 <- create_dxfs_style()

# change font color and background color
style2 <- create_dxfs_style(
  font_color = wb_color(hex = "FF9C0006"),
  bgFill = wb_color(hex = "FFFFC7CE")
)

# change font (type, size and color) and background
# the old default in openxlsx and openxlsx2 <= 0.3
style3 <- create_dxfs_style(
  font_name = "Calibri",
  font_size = 11,
  font_color = wb_color(hex = "FF9C0006"),
  bgFill = wb_color(hex = "FFFFC7CE")
)

## See package vignettes for further examples
}
\seealso{
\code{\link[=wb_add_style]{wb_add_style()}}
}
