% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-isochrone.R
\name{otp_isochrone}
\alias{otp_isochrone}
\title{Get the Isochrones from a location}
\usage{
otp_isochrone(
  otpcon = NA,
  fromPlace = NA,
  mode = "TRANSIT",
  date_time = Sys.time(),
  arriveBy = FALSE,
  maxWalkDistance = 800,
  walkReluctance = 5,
  transferPenalty = 0,
  minTransferTime = 600,
  cutoffSec = c(600, 1200, 1800, 2400, 3000, 3600)
)
}
\arguments{
\item{otpcon}{OTP connection object produced by otp_connect()}

\item{fromPlace}{Numeric vector, Longitude/Latitude pair,
e.g. `c(-0.134649, 51.529258,)`}

\item{mode}{character vector of one or more modes of travel valid values
TRANSIT, WALK, BICYCLE, CAR, BUS, RAIL, default CAR. Not all
combinations are valid e.g. c("WALK","BUS") is valid but
c("WALK","CAR") is not.}

\item{date_time}{POSIXct, a date and time, defaults to current
date and time}

\item{arriveBy}{Logical, Whether the trip should depart or
arrive at the specified date and time, default FALSE}

\item{maxWalkDistance}{Numeric passed to OTP in metres}

\item{walkReluctance}{Numeric passed to OTP}

\item{transferPenalty}{Numeric passed to OTP in seconds}

\item{minTransferTime}{Numeric passed to OTP}

\item{cutoffSec}{Numeric vector, number of seconds to define
the break points of each Isochrone}
}
\value{
Returns a SF data.frame of POLYGONs
}
\description{
Get the Isochrones from a location
}
\details{
Isochrones are maps of equal travel time,
for a given location a map is produced showing how long it takes to reach
each location.

This feature is known to not work correctly with any mode other than TRANSIT.
}
\examples{
\dontrun{
isochrone1 <- otp_isochrone(otpcon, fromPlace = c(-0.1346, 51.5292))
isochrone2 <- otp_isochrone(otpcon,
  fromPlace = c(-0.1346, 51.5292),
  mode = c("WALK", "TRANSIT"), cutoffSec = c(600, 1200, 1800)
)
}
}
\seealso{
Other routing: 
\code{\link{otp_geocode}()},
\code{\link{otp_plan}()}
}
\concept{routing}
