% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat.R
\name{repeat_count}
\alias{repeat_count}
\alias{repeat_count<-}
\title{Get or set the repeat count for an \code{openmpt} module}
\usage{
repeat_count(mod, ...)

repeat_count(mod, ...) <- value
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{...}{Ignored}

\item{value}{An \code{integer} value to assign to the repeat count.}
}
\value{
Returns the \code{integer} repeat count of an \code{openmpt} object. In case
of an assign operator (\verb{<-}) an updated \code{mod} is returned with the new repeat count.
}
\description{
Tracker music can be composed such that it is intended to play
in a continuous loop. With the repeat count you can affect the number of
times a module is repeated when playing with \code{\link[=play]{play()}} or rendered with \code{\link[=convert_mod]{convert_mod()}}.
}
\examples{
mod <- demo_mod()
repeat_count(mod) <- 2
repeat_count(mod)
}
