% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marine_forecast.R
\name{marine_forecast}
\alias{marine_forecast}
\title{Retrieve marine conditions data from the Open-Meteo API}
\usage{
marine_forecast(
  location,
  start = NULL,
  end = NULL,
  hourly = NULL,
  daily = NULL,
  response_units = NULL,
  timezone = "auto"
)
}
\arguments{
\item{location}{Required. The location for which data will be retrieved.
Supplied as either a \code{c(latitude,longitude)} WGS84 coordinate pair or a
place name string (with co-ordinates obtained via \code{\link[=geocode]{geocode()}}).}

\item{start, end}{Start and end dates in ISO 8601 (e.g. "2020-12-31"). If no
dates are supplied, data for the next 7 days will be provided by default.}

\item{hourly, daily}{At least one required. A marine weather variable accepted
by the API, or list thereof. See details below.}

\item{response_units}{Supply to convert response units for wave heights. This
defaults to: \verb{list(length_unit="metric") for meters. Specify "Imperial" for feet.}}

\item{timezone}{specify timezone for time data as a string, i.e.
"australia/sydney" (defaults to "auto", the timezone local to the specified
\code{location}).}
}
\value{
Requested marine conditions data for the given location and time, as
a tidy tibble.
}
\description{
\code{marine_forecast()} calls the Open-Meteo Marine Forecast API to obtain swell
and wave data for a given location. Limited historical data is also available
via this API.

Refer to the API documentation at:
\url{https://open-meteo.com/en/docs/marine-weather-api}
}
\details{
You will need to specify at least one variable to retrieve, such as wave
height, that you want data for. These variables are sampled or aggregated at
\emph{hourly} or \emph{daily} intervals, and can be supplied as a list to request
multiple variables over the same time period.

Example \emph{Hourly} variables include:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{wave_height} \tab Wave height of significant mean waves \cr
   \code{wind_wave_height} \tab Wave height of significant wind waves \cr
   \code{swell_wave_height} \tab Wave height of significant swell waves \cr
   \code{wind_wave_direction} \tab Mean direction of wind waves \cr
   \code{swell_wave_period} \tab Mean period between swell waves \cr
}


Example \emph{Daily} variables include:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{wave_height_max} \tab Maximum wave height for mean waves \cr
   \code{wind_wave_direction_dominant} \tab Dominant wave direction of wind waves \cr
   \code{swell_wave_period_max} \tab Maximum wave period of swell waves \cr
}


Full documentation for the marine API is available at:
\url{https://open-meteo.com/en/docs/marine-weather-api}
}
\examples{
\donttest{
# Obtain maximum wave heights in Nazare, Portugal, over the next week
marine_forecast("Nazare", daily = "wave_height_max")
}
}
