#' Survey on sleep deprivation and transportation workers
#'
#' The National Sleep Foundation conducted a survey on the sleep habits of
#' randomly sampled transportation workers and a control sample of
#' non-transportation workers.
#'
#'
#' @name sleep_deprivation
#' @docType data
#' @format A data frame with 1087 observations on the following 2 variables.
#' \describe{
#'   \item{sleep}{a factor with levels \code{<6}, \code{6-8}, and \code{>8}}
#'   \item{profession}{a factor with levels \code{bus / taxi / limo drivers},
#'   \code{control}, \code{pilots}, \code{train operators}, \code{truck drivers}}
#'   }
#' @source National Sleep Foundation, 2012 Sleep in America Poll:
#' Transportation Workers' Sleep, 2012.
#' \url{https://www.sleepfoundation.org/professionals/sleep-americar-polls/2012-sleep-america-poll-transportation-workers-sleep}
#' @keywords datasets
#' @examples
#'
#' sleep_deprivation
"sleep_deprivation"
