% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_pkg_data.R
\name{write_pkg_data}
\alias{write_pkg_data}
\title{Create a CSV variant of .rda files}
\usage{
write_pkg_data(
  pkg,
  dir = paste0("data-", out_type),
  overwrite = FALSE,
  out_type = c("csv", "tab", "R")
)
}
\arguments{
\item{pkg}{The R package where we'd like to generate CSVs of any
data frames.}

\item{dir}{A character string representing the path to the folder.
where the CSV files should be written. If no such directory
exists, one will be created (recursively).}

\item{overwrite}{Boolean to indicate if to overwrite any existing
files that have conflicting names in the directory specified.}

\item{out_type}{Format for the type of output as a CSV (\code{"csv"}),
tab-delimited text file (\code{"tab"}), or the R code to generate
the object (\code{"R"}).}
}
\description{
The function should be run with a path to a package directory.
It will then look through the \code{data} directory of the package,
and for all data sets that are data frames, create CSV variants
in a \code{data-csv} directory.
}
\examples{
\dontrun{
write_pkg_data("openintro")
list.files("data-csv")
}
}
