% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-sa_gdp_elec.R
\docType{data}
\name{sa_gdp_elec}
\alias{sa_gdp_elec}
\title{Sustainability and Economic Indicators for South Africa.}
\format{
A data frame with 16 rows and 7 variables.
\describe{
\item{year}{Year data collected.}
\item{access_elec}{Access to electricity as a percentage of the population.}
\item{startup}{cost of business startup procedures as a percent of GNI.}
\item{co2}{CO2 emission in kt (kiloton).}
\item{gdp}{GDP per capita, PPP in constant 2017 international dollars.}
\item{gni}{GNI per capita, PPP in constant 2017 international dollars.}
\item{co2_kg_ppp}{kg per 2017 PPP dollars of GDP.}
}
}
\source{
\itemize{
\item \href{https://databank.worldbank.org/source/world-development-indicators}{World Bank I}
\item \href{https://www.worldbank.org/en/programs/business-enabling-environment}{World Bank II}
\item \href{https://www.climatewatchdata.org}{Carbon Dioxide Information Analysis Center, Environmental Sciences Division, Oak Ridge National Laboratory}
}
}
\usage{
sa_gdp_elec
}
\description{
Includes yearly data on gdp, gni, co2 emissions, start up costs.
}
\examples{
library(ggplot2)

ggplot(sa_gdp_elec, aes(year, access_elec))+
 geom_point(alpha = 0.3) +
 labs( x= "Year",
       y = "Percent of Population",
       title = "Access to Electricity in South Africa 2003 - 2018")

}
\keyword{datasets}
