% Generated by roxygen2 (4.0.1): do not edit by hand
\name{polarAnnulus}
\alias{polarAnnulus}
\title{Bivariate polarAnnulus plot}
\usage{
polarAnnulus(mydata, pollutant = "nox", resolution = "fine",
  local.tz = NULL, period = "hour", type = "default",
  statistic = "mean", percentile = NA, limits = c(0, 100),
  cols = "default", width = "normal", min.bin = 1,
  exclude.missing = TRUE, date.pad = FALSE, force.positive = TRUE,
  k = c(20, 10), normalise = FALSE, key.header = "",
  key.footer = pollutant, key.position = "right", key = TRUE,
  auto.text = TRUE, ...)
}
\arguments{
\item{mydata}{A data frame minimally containing \code{date}, \code{wd} and
a pollutant.}

\item{pollutant}{Mandatory. A pollutant name corresponding to a
variable in a data frame should be supplied e.g. \code{pollutant =
"nox"}. There can also be more than one pollutant specified
e.g. \code{pollutant = c("nox", "no2")}. The main use of using two
or more pollutants is for model evaluation where two species would
be expected to have similar concentrations. This saves the user
stacking the data and it is possible to work with columns of data
directly. A typical use would be \code{pollutant = c("obs",
"mod")} to compare two columns \dQuote{obs} (the observations) and
\dQuote{mod} (modelled values).}

\item{resolution}{Two plot resolutions can be set: \dQuote{normal} and
\dQuote{fine} (the default).}

\item{local.tz}{Should the results be calculated in local time
that includes a treatment of daylight savings time (DST)? The
default is not to consider DST issues, provided the data were
imported without a DST offset. Emissions activity tends to occur
at local time e.g. rush hour is at 8 am every day. When the clocks
go forward in spring, the emissions are effectively released into
the atmosphere typically 1 hour earlier during the summertime
i.e. when DST applies. When plotting diurnal profiles, this has
the effect of \dQuote{smearing-out} the concentrations. Sometimes,
a useful approach is to express time as local time. This
correction tends to produce better-defined diurnal profiles of
concentration (or other variables) and allows a better comparison
to be made with emissions/activity data. If set to \code{FALSE}
then GMT is used. Examples of usage include \code{local.tz =
"Europe/London"}, \code{local.tz = "America/New_York"}. See
\code{cutData} and \code{import} for more details.}

\item{period}{This determines the temporal period to
consider. Options are \dQuote{hour} (the default, to plot diurnal
variations), \dQuote{season} to plot variation throughout the
year, \dQuote{weekday} to plot day of the week variation and
\dQuote{trend} to plot the trend by wind direction.}

\item{type}{\code{type} determines how the data are split
i.e. conditioned, and then plotted. The default is will produce a
single plot using the entire data. Type can be one of the built-in
types as detailed in \code{cutData} e.g. \dQuote{season},
\dQuote{year}, \dQuote{weekday} and so on. For example, \code{type
= "season"} will produce four plots --- one for each season.

It is also possible to choose \code{type} as another variable in
the data frame. If that variable is numeric, then the data will be
split into four quantiles (if possible) and labelled
accordingly. If type is an existing character or factor variable,
then those categories/levels will be used directly. This offers
great flexibility for understanding the variation of different
variables and how they depend on one another.

Type can be up length two e.g. \code{type = c("season", "site")} will
  produce a 2x2 plot split by season and site. The use of two types is
  mostly meant for situations where there are several sites. Note, when two
  types are provided the first forms the columns and the second the rows.

Also note that for the \code{polarAnnulus} function some type/period
  combinations are forbidden or make little sense. For example, \code{type
  = "season"} and \code{period = "trend"} (which would result in a plot
  with too many gaps in it for sensible smoothing), or \code{type =
  "weekday"} and \code{period = "weekday"}.}

\item{statistic}{The statistic that should be applied to each wind
speed/direction bin. Can be \dQuote{mean} (default),
\dQuote{median}, \dQuote{max} (maximum),
\dQuote{frequency}. \dQuote{stdev} (standard deviation),
\dQuote{weighted.mean} or \dQuote{cpf} (Conditional Probability
Function). Because of the smoothing involved, the colour scale for
some of these statistics is only to provide an indication of
overall pattern and should not be interpreted in concentration
units e.g. for \code{statistic = "weighted.mean"} where the bin
mean is multiplied by the bin frequency and divided by the total
frequency. In many cases using \code{polarFreq} will be
better. Setting \code{statistic = "weighted.mean"} can be useful
because it provides an indication of the concentration * frequency
of occurrence and will highlight the wind speed/direction
conditions that dominate the overall mean.}

\item{percentile}{If \code{statistic = "percentile"} or
\code{statistic = "cpf"} then \code{percentile} is used, expressed
from 0 to 100. Note that the percentile value is calculated in the
wind speed, wind direction \sQuote{bins}. For this reason it can
also be useful to set \code{min.bin} to ensure there are a
sufficient number of points available to estimate a
percentile. See \code{quantile} for more details of how
percentiles are calculated.}

\item{limits}{Limits for colour scale.}

\item{cols}{Colours to be used for plotting. Options include
\dQuote{default}, \dQuote{increment}, \dQuote{heat}, \dQuote{jet}
and user defined. For user defined the user can supply a list of
colour names recognised by R (type \code{colours()} to see the
full list). An example would be \code{cols = c("yellow", "green",
"blue")}}

\item{width}{The width of the annulus; can be \dQuote{normal} (the
default), \dQuote{thin} or \dQuote{fat}.}

\item{min.bin}{The minimum number of points allowed in a wind speed/wind
direction bin.  The default is 1. A value of two requires at least 2
valid records in each bin an so on; bins with less than 2 valid records
are set to NA. Care should be taken when using a value > 1 because of the
risk of removing real data points. It is recommended to consider your
data with care. Also, the \code{polarFreq} function can be of use in such
circumstances.}

\item{exclude.missing}{Setting this option to \code{TRUE} (the default)
removes points from the plot that are too far from the original data. The
smoothing routines will produce predictions at points where no data exist
i.e. they predict. By removing the points too far from the original data
produces a plot where it is clear where the original data lie. If set to
\code{FALSE} missing data will be interpolated.}

\item{date.pad}{For \code{type = "trend"} (default), \code{date.pad = TRUE}
will pad-out missing data to the beginning of the first year and the end
of the last year. The purpose is to ensure that the trend plot begins and
ends at the beginning or end of year.}

\item{force.positive}{The default is \code{TRUE}. Sometimes if smoothing
data with steep gradients it is possible for predicted values to be
negative. \code{force.positive = TRUE} ensures that predictions remain
postive. This is useful for several reasons. First, with lots of missing
data more interpolation is needed and this can result in artifacts
because the predictions are too far from the original data. Second, if it
is known beforehand that the data are all postive, then this option
carries that assumption through to the prediction. The only likely time
where setting \code{force.positive = FALSE} would be if background
concentrations were first subtracted resulting in data that is
legitimately negative. For the vast majority of situations it is expected
that the user will not need to alter the default option.}

\item{k}{The smoothing value supplied to \code{gam} for the temporal and
wind direction components, respectively. In some cases e.g. a trend plot
with less than 1-year of data the smoothing with the default values may
become too noisy and affected more by outliers. Choosing a lower value of
\code{k} (say 10) may help produce a better plot.}

\item{normalise}{If \code{TRUE} concentrations are normalised by dividing
by their mean value. This is done \emph{after} fitting the smooth
surface. This option is particularly useful if one is interested in the
patterns of concentrations for several pollutants on different scales
e.g. NOx and CO. Often useful if more than one \code{pollutant} is
chosen.}

\item{key.header}{Adds additional text/labels to the scale key.
For example, passing the options \code{key.header = "header", key.footer
= "footer1"} adds addition text above and below the scale key. These
arguments are passed to \code{drawOpenKey} via \code{quickText}, applying
the \code{auto.text} argument, to handle formatting.}

\item{key.footer}{see \code{key.header}.}

\item{key.position}{Location where the scale key is to plotted.
Allowed arguments currently include \dQuote{top}, \dQuote{right},
\dQuote{bottom} and \dQuote{left}.}

\item{key}{Fine control of the scale key via \code{drawOpenKey}. See
\code{drawOpenKey} for further details.}

\item{auto.text}{Either \code{TRUE} (default) or \code{FALSE}. If
\code{TRUE} titles and axis labels will automatically try and format
pollutant names and units properly e.g.  by subscripting the \sQuote{2}
in NO2.}

\item{...}{Other graphical parameters passed onto \code{lattice:levelplot}
and \code{cutData}. For example, \code{polarAnnulus} passes the option
\code{hemisphere = "southern"} on to \code{cutData} to provide southern
(rather than default northern) hemisphere handling of \code{type = "season"}.
Similarly, common axis and title labelling options (such as \code{xlab},
\code{ylab}, \code{main}) are passed to \code{levelplot} via \code{quickText}
to handle routine formatting.}
}
\value{
As well as generating the plot itself, \code{polarAnnulus} also
  returns an object of class ``openair''. The object includes three main
  components: \code{call}, the command used to generate the plot;
  \code{data}, the data frame of summarised information used to make the
  plot; and \code{plot}, the plot itself. If retained, e.g. using
  \code{output <- polarAnnulus(mydata, "nox")}, this output can be used to
  recover the data, reproduce or rework the original plot or undertake
  further analysis.

An openair output can be manipulated using a number of generic operations,
  including \code{print}, \code{plot} and \code{summary}.
}
\description{
Typically plots the concentration of a pollutant by wind direction and as a
function of time as an annulus. The function is good for visualising how
concentrations of pollutants vary by wind direction and a time period e.g.
by month, day of week.
}
\details{
The \code{polarAnnulus} function shares many of the properties of the
\code{polarPlot}. However, \code{polarAnnulus} is focussed on displaying
information on how concentrations of a pollutant (values of another
variable) vary with wind direction and time. Plotting as an annulus helps
to reduce compression of information towards the centre of the plot. The
circular plot is easy to interpret because wind direction is most easily
understood in polar rather than Cartesian coordinates.

The inner part of the annulus represents the earliest time and the outer
part of the annulus the latest time. The time dimension can be shown in
many ways including "trend", "hour" (hour or day), "season" (month of the
year) and "weekday" (day of the week). Taking hour as an example, the plot
will show how concentrations vary by hour of the day and wind direction.
Such plots can be very useful for understanding how different source
influences affect a location.

For \code{type = "trend"} the amount of smoothing does not vary linearly
with the length of the time series i.e. a certain amount of smoothing per
unit interval in time. This is a deliberate choice because should one be
interested in a subset (in time) of data, more detail will be provided for
the subset compared with the full data set. This allows users to
investigate specific periods in more detail. Full flexibility is given
through the smoothing parameter \code{k}.
}
\examples{
# load example data from package
data(mydata)

# diurnal plot for PM10 at Marylebone Rd
polarAnnulus(mydata, pollutant = "pm10", main = "diurnal variation in pm10 at Marylebone Road")

# seasonal plot for PM10 at Marylebone Rd
\dontrun{polarAnnulus(mydata, poll="pm10", period = "season")}

# trend in coarse particles (PMc = PM10 - PM2.5), calculate PMc first

mydata$pmc <- mydata$pm10 - mydata$pm25
\dontrun{polarAnnulus(mydata, poll="pmc", period = "trend",
main = "trend in pmc at Marylebone Road")}
}
\author{
David Carslaw
}
\seealso{
\code{\link{polarPlot}}, \code{\link{polarFreq}},
  \code{\link{pollutionRose}} and \code{\link{percentileRose}}
}
\keyword{methods}

