\name{GoogleMapsPlot}
\alias{GoogleMapsPlot}
\alias{panel.GoogleMaps}
\alias{panel.GoogleMapsRaster}
\title{GoogleMapsPlot}
\usage{
  GoogleMapsPlot(mydata, latitude = "latitude",
    longitude = "longitude", type = "default", xlim, ylim,
    pollutant = NULL, labels = NULL, cols = "default",
    limits = c(0, 100), cex = pollutant, pch = NULL,
    cex.range = c(2, 10), xlab = longitude,
    ylab = latitude, main = "", axes = TRUE, map = NULL,
    map.raster = TRUE, map.cols = NULL, aspect = 1,
    as.table = TRUE, plot.type = "xy",
    plot.transparent = FALSE, key = NULL,
    key.position = "right", key.header = "",
    key.footer = pollutant, auto.text = TRUE, ...)
}
\arguments{
  \item{mydata}{The openair data frame to use to generate
  the \code{GoogleMapsPlot} plot.}

  \item{latitude,longitude}{The names of the data series in
  \code{mydata} giving the latitudes and longitudes,
  respectively, of measurements.}

  \item{type}{The type of data conditioning to apply before
  plotting. The default is will produce a single plot using
  the entire data. Other type options include "hour" (for
  hour of the day), "weekday" (for day of the week) and
  "month" (for month of the year), "year", "season"
  (string, summer, autumn or winter) and "daylight"
  (daylight or nighttime hour).  But it is also possible to
  set \code{type} to the name of another variable in
  \code{mydata}, in which case the plotted data will be
  divided into quantiles based on that data series. See
  \code{cutData} for further details.(NOTE: type
  conditioning currently allows up to two levels of
  conditioning, e.g., \code{type = c("weekday",
  "daylight")}.)}

  \item{xlim,ylim}{The x-axis and y-axis size ranges. By
  default these sized on the basis of \code{latitude} and
  \code{longitude}, but can be forced as part of the plot
  call [NOTE: This IN DEVELOPMENT option is currently
  restricted and requested ranges are forced square to
  maintain map aspect ratio.].}

  \item{pollutant}{If supplied, the name of a pollutant or
  variable in \code{mydata} that is to be evaluated at the
  each measurement point.  Depending on settings, nominally
  \code{cols} and \code{cex}, the evaluation can be by
  colour, size or both.}

  \item{labels}{If supplied, either the name of
  \code{mydata} column/field containing the labels to be
  used or a list, containing that field name (as
  \code{labels}), and any other label properties, e.g.
  \code{cex}, \code{col}, etc, required for fine-tuning
  label appearance.}

  \item{cols}{The colour set to use to colour scaled data.
  Typically, \code{cols} is passed to \code{openColours}
  for evaluation, but can be forced to one colour using
  e.g. \code{col = "red"}. The special case \code{cols =
  "greyscale"} forces all plot components (the map, the
  data layer and the plot strip of \code{type}
  conditioning) to greyscale for black and white printing.
  See \code{?openColours} for more details.}

  \item{limits}{By default, the data colour scale is fitted
  to the total data range. However, there are circumstances
  when the user may wish to set different ones. In such
  cases \code{limits} can be set in the form \code{c(lower,
  upper)} to modify the colour range.}

  \item{cex}{The size of data points plotted on maps. By
  default this \code{NULL} or \code{pollutant} if supplied.
  If \code{NULL} all points are plotted an equal size. If
  \code{pollutant} or the name of another variable in
  \code{mydata} this is used by scaled using
  \code{cex.range}.  If necessary, \code{cex} can also be
  forced, e.g. \code{cex = 1} to make all points the same
  size.}

  \item{pch}{The plot symbol to be used when plotting data.
  By default this is a solid circle (\code{pch = 20}), but
  can be any predefined symbol, e.g. \code{pch = 1} is the
  open circle symbol used in most standard R plots.
  \code{pch} may also be the name of a variable in
  \code{mydata} for local control.}

  \item{cex.range}{The range to rescale \code{cex} values
  to if \code{cex} is supplied as a \code{mydata} variable
  name. This is intended to provide sensible data point
  points regardless of the variable value range but may be
  require fine-tuning.}

  \item{xlab,ylab,main}{The x-axis, y-axis and main title
  labels to be added to the plot. All labels are passed via
  \code{quickText} to handle formatting if enabled
  (\code{auto.text = TRUE}). By default
  \code{GoogleMapsPlot} uses \code{latitude} and
  \code{longitude} names as xlab and ylab, respectively.}

  \item{axes}{An alternative (short hand) option to
  add/remove (\code{TRUE}/\code{FALSE}) all x and y axis
  annotation and labelling.}

  \item{map}{If supplied, an \code{RgoogleMaps} output, to
  be used as a background map. If \code{NULL} (as in
  default), a map is produced using the \code{RgoogleMaps}
  function \code{MapBackground}, the supplied
  \code{latitude} and \code{longitude} ranges, and any
  additional \code{RgoogleMaps} arguments supplied as part
  of the plot call.  (Note: the \code{map} object currently
  used in \code{panel...} functions is a modified form of
  this output, details to be confirmed.)}

  \item{map.raster}{Should the map be plotted as a raster
  object? The default \code{TRUE} uses
  \code{panel.GoogleMapsRaster} to produce the map layer,
  while the alternative (\code{FALSE}) uses
  \code{panel.GoogleMaps}. (NOTE: The raster version is
  typically much faster but may not be available for all
  computer systems.)}

  \item{map.cols}{Like \code{cols} a colour scale, but, if
  supplied, used to recolour the map layer before plotting.
  (NOTE: If set, this will override \code{cols =
  "greyscale"}.)}

  \item{aspect}{The aspect ratio of the plot.}

  \item{as.table}{\code{as.table} is a \code{lattice}
  option that controls the order in which multiple panels
  are displayed. The default (\code{TRUE}) produces layouts
  similar to other openair plot.}

  \item{plot.type}{The method to use to produce the data
  layer for the plot.  By default (\code{plot.type =
  "xy"}), this is an x-y style scatter plot, but can also
  be other pre-defined options (e.g. "level" for a
  levelplot) or a user-defined panel of a similar structire
  to \code{panel...} functions in \code{lattice}.}

  \item{plot.transparent}{Data layer transparency control.
  When enabled, this forces colours used in the data layer
  to transparent, and can be a numeric setting the colour
  density, from invisible (0) to solid (1), or a logical
  (\code{TRUE} applying default 0.5). Note: User-defined
  colours (and some panel defaults when supplying
  specialist functions using e.g.  \code{plot.type =
  panel...}) may sometimes supersede this option.}

  \item{key}{Fine control for the color scale key. By
  default (\code{key = NULL}) the key is generated is a
  colour range exists, but can be forced (\code{key =
  TRUE/FALSE}) or controlled at a higher level (via
  \code{drawOpenKey}).}

  \item{key.position}{Location where the scale key should
  be plotted.  Allowed arguments currently include
  \code{"top"}, \code{"right"}, \code{"bottom"} and
  \code{"left"}.}

  \item{key.header,key.footer}{Header and footer labels to
  add to colour key, if drawn. If enabled (\code{auto.text
  = TRUE}), these arguments are passed to the scale key
  (\code{drawOpenKey}) via \code{quickText} to handle
  formatting.}

  \item{auto.text}{Automatic routine text formatting.
  \code{auto.text = TRUE} allows labels (\code{xlab},
  \code{ylab}, \code{main}, etc.) to be passed to the plot
  via \code{quickText}.  \code{auto.text = FALSE} turns
  this option off and passes labels to the plot without
  modification.}

  \item{...}{Addition options are passed on to
  \code{cutData} for \code{type} handling,
  \code{MapBackground} in \code{RgoogleMaps} for map layer
  production, and \code{xyplot} in \code{lattice} for data
  layer production.}
}
\value{
  As well as generating the plot itself,
  \code{GoogleMapsPlot} also returns an object of class
  ``openair''. The object includes three main components:
  \code{call}, the command used to generate the plot;
  \code{data}, the data frame of summarised information
  used to make the plot; and \code{plot}, the plot itself.
  If retained, e.g. using \code{output <-
  GoogleMapsPlot(mydata)}, this output can be used to
  recover the data, reproduce or rework the original plot
  or undertake further analysis.

  An openair output can be manipulated using a number of
  generic operations, including \code{print}, \code{plot}
  and \code{summary}. See \code{\link{openair.generics}}
  for further details.
}
\description{
  [IN DEVELOPMENT] Map plotting for openair data sets.
}
\details{
  \code{GoogleMapsPlot} is an IN DEVELOPMENT function.

  It combines a dedicated map layer, e.g.
  \code{\link{panel.GoogleMaps}}, or (the default)
  \code{\link{panel.GoogleMapsRaster}}, and standard
  \code{\link{lattice}} panels such as
  \code{\link[lattice]{panel.xyplot}} or
  \code{\link[lattice]{panel.levelplot}} as a data layer,
  to produce map-based data visualisations.

  It provides lattice-style conditioning/handling for
  \code{\link[RgoogleMaps]{RgoogleMaps}} outputs.
}
\note{
  IN DEVELOPMENT: HANDLE WITH CARE.

  Users should be aware that Google Maps are flat 2D
  projections of the Earth's (curved) surface. Latitude and
  longitude scales are therefore locally modified to
  account for this.
}
\examples{
#TO BE CONFIRMED
}
\author{
  Karl Ropkins
}
\references{
  This function makes extensive use of code developed by
  others.

  RgoogleMaps: Markus Loecher and Sense Networks (2011).
  RgoogleMaps: Overlays on Google map tiles in R. R package
  version 1.1.9.6.
  http://CRAN.R-project.org/package=RgoogleMaps

  lattice: Sarkar, Deepayan (2008) Lattice: Multivariate
  Data Visualization with R. Springer, New York. ISBN
  978-0-387-75968-5
}
\seealso{
  \code{\link[RgoogleMaps]{MapBackground}},
  \code{\link[lattice]{xyplot}},
  \code{\link[lattice]{panel.xyplot}} and
  \code{\link[lattice]{panel.levelplot}}
}
\keyword{methods}

