% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_vector_data}
\alias{import_vector_data}
\title{Import vector data into GRASS.}
\usage{
import_vector_data(data, name, layer = NULL, proj_ref_obj = NULL, snap = -1)
}
\arguments{
\item{data}{character string or object; path to data vector file (shape), postgis 
data source name (dsn; see details), or sp or sf data object.}

\item{name}{string giving the base name of the vector data within the GRASS envrionment (i.e. output)}

\item{layer}{character string; default 1, particularly needed if data is a dsn for 
importing postgis data (see details)}

\item{proj_ref_obj}{character; path to a georeferenced data file to be used as reference; only
used if \code{data} is an sf of sp object, then, the two projections are compared to find the
correct way for importing; typically the dem raster file used in this project.}

\item{snap}{float; snapping threshold in map units. If != -1 (default) vertices are snapped to other vertices
in this snapping distance during import. If used, the features are automatically cleaned afterwards 
(see GRASS tools \href{https://grass.osgeo.org/grass74/manuals/v.import.html}{v.import}  
and \href{https://grass.osgeo.org/grass74/manuals/v.clean.html}{v.clean} )}
}
\value{
Nothing.
}
\description{
Generic function to import vector data of various formats into the GRASS environment.
}
\details{
For importing data from Postgis, all data base credentials must be supplied 
 in \code{data} and the correct \code{layer} and, if the table containing the polygons
 are in a specific schema also that one (see example)
}
\examples{
# import data from Postgis
\dontrun{
import_vector_data(data = "PG: 'pgname=postgit_DB', 'host=123.45.67.890', 
'port='1234', 'user=username', 'password=password'",
 name = "forest", layer = "landuse_schema.forest")
}

}
\author{
Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}
}
