% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{opal.table_exists}
\alias{opal.table_exists}
\title{Check a Opal table exists}
\usage{
opal.table_exists(opal, project, table, view = NA)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the table is located.}

\item{table}{Table name.}

\item{view}{Logical to perform an additional check whether the table is a view (TRUE) or a raw table (FALSE).
If NULL or NA, the table can be indifferently a view or a raw table. Default is NA.}
}
\description{
Check whether a Opal table exists (and is visible). Optionally check whether the table is a raw table 
or a view.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# check table exists
opal.table_exists(o, "CNSIM", "CNSIM1")
# check table exists AND is a NOT a view
opal.table_exists(o, "CNSIM", "CNSIM1", view = FALSE)
# check table exists AND is a view
opal.table_exists(o, "CNSIM", "CNSIM1", view = TRUE)
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.perms}()},
\code{\link{opal.resource_view_create}()},
\code{\link{opal.resource_view_reconnect}()},
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()},
\code{\link{opal.table_view_create}()},
\code{\link{opal.table_view_update}()}
}
\concept{table functions}
