% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.users.R
\name{oadmin.user_delete}
\alias{oadmin.user_delete}
\title{Delete a user}
\usage{
oadmin.user_delete(opal, name)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{User name}
}
\description{
Delete a user from Opal internal users registry. Fails silently if user does not exist.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
pwd <- oadmin.user_add(o, "foo", groups = c("datashield", "CNSIM"))
oadmin.user_delete(o, "foo")
opal.logout(o)
}
}
\seealso{
Other user functions: 
\code{\link{oadmin.user_add}()},
\code{\link{oadmin.user_enable}()},
\code{\link{oadmin.user_exists}()},
\code{\link{oadmin.user_profile_delete}()},
\code{\link{oadmin.user_profiles}()},
\code{\link{oadmin.user_reset_password}()},
\code{\link{oadmin.users}()}
}
\concept{user functions}
