% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.datasource.R
\name{opal.table}
\alias{opal.table}
\title{Get a table of a datasource}
\usage{
opal.table(opal, datasource, table, counts = FALSE)
}
\arguments{
\item{opal}{Opal object.}

\item{datasource}{Name of the datasource.}

\item{table}{Name of the table in the datasource.}

\item{counts}{Flag to get the number of variables and entities (default is FALSE).}
}
\description{
Get a table of a datasource
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.table(o, 'datashield', 'CNSIM1')
opal.logout(o)
}
}
\seealso{
Other datasource functions: 
\code{\link{opal.annotate}()},
\code{\link{opal.annotations}()},
\code{\link{opal.attribute_values}()},
\code{\link{opal.datasources}()},
\code{\link{opal.datasource}()},
\code{\link{opal.tables}()},
\code{\link{opal.valueset}()},
\code{\link{opal.variables}()},
\code{\link{opal.variable}()}
}
\concept{datasource functions}
