% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{group_results}
\alias{group_results}
\title{Group-level PCC and chance values.}
\usage{
group_results(m, digits)
}
\arguments{
\item{m}{an object of class "opafit" produced by \code{opa()}.}

\item{digits}{a positive integer.}
}
\value{
a matrix with 1 row per group.
}
\description{
Group-level PCC and chance values.
}
\details{
If the model was fitted with no grouping variable, a single PCC and c-value
are returned. If a grouping variable was specified in the call to \code{opa}
then PCCs and c-values are returned for each factor level of the grouping
variable.
}
\examples{
dat <- data.frame(t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11))
opamod <- opa(dat, 1:3)
group_results(opamod)
}
