% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.R
\name{plot_bar}
\alias{plot_bar}
\title{Create a bar plot}
\usage{
plot_bar(fc_data, fill, size = c(1, 1), outline_color = c("black", "black"))
}
\arguments{
\item{fc_data}{The output file from Count_Fold_Changes}

\item{fill}{A character vector of length 2 containing colors for filling the bars,
the first color is for the "Decrease" bar while the second
is for "Increase"}

\item{size}{A numeric vector of 2 numbers for the size of the bar outlines.}

\item{outline_color}{A character vector of length 2 containing colors for the bar outlines}
}
\description{
Creates a ggplot2 object using the output file from the count_fold_changes function
}
\examples{
c57_nos2KO_mouse_countDF <- assign_hierarchy(c57_nos2KO_mouse_countDF, TRUE, "KEGG")
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:20,]}
t_test_df <- omu_summary(count_data = c57_nos2KO_mouse_countDF,
metadata = c57_nos2KO_mouse_metadata, numerator = "Strep", denominator = "Mock",
response_variable = "Metabolite", Factor = "Treatment",
log_transform = TRUE, p_adjust = "BH", test_type = "welch")

fold_change_counts <- count_fold_changes(count_data = t_test_df,
column = "Class", sig_threshold = 0.05, keep_unknowns = FALSE)

plot_bar(fc_data = fold_change_counts, fill = c("firebrick2", "dodgerblue2"),
outline_color = c("black", "black"), size = c(1,1))
}
