% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-api.R
\name{extract_constraints}
\alias{extract_constraints}
\title{Extract the constraint matrix, the right hand side and the sense from a model}
\usage{
extract_constraints(model)
}
\arguments{
\item{model}{the model}
}
\value{
a list with three named elements.
        'matrix' is the constraint matrix.
        'rhs' is the right hand side vector in the order of the matrix.
        'sense' is a vector of the constraint senses
}
\description{
Extract the constraint matrix, the right hand side and the sense from a model
}
\examples{
library(magrittr)
model <- MIPModel() \%>\%
  add_variable(x[i], i = 1:3) \%>\%
  add_variable(y[i], i = 1:3) \%>\%
  add_constraint(x[i] + y[i] <= 1, i = 1:3)
extract_constraints(model)
}
