% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treemap_interval.R
\name{treemap_interval}
\alias{treemap_interval}
\title{Creates a treemap for a given period of years}
\usage{
treemap_interval(origin, dest, variable, initial_year, final_year,
  classification, interval, depth)
}
\arguments{
\item{origin}{is the country code of origin (e.g. "chl" for Chile)}

\item{dest}{is the country code of destination (e.g. "chn" for China)}

\item{variable}{is the variable to visualize and it can be "imports", "exports" or "exchange" (trade exchange)}

\item{initial_year}{is the initial year and the OEC's API ranges from 1942 to 2014}

\item{final_year}{is the final year and the OEC's API ranges from 1942 to 2014}

\item{classification}{Trade classification that can be "1" (HS92 4 characters since year 1995), "2" (SITC rev.3 4 characters since year 1962) or "3" (HS92 6 characters since year 1995)}

\item{interval}{is an optional parameter to define the distance between years (by default set to 1)}

\item{depth}{is an optional parameter that can take values "0" (group's detail) or "1" (product's detail), by defaults its set to 1}
}
\value{
Creates an \code{HTML} file with a treemap visualization for a given period of years.
}
\description{
Creates a treemap for a given period of years
}
\examples{
# Run countries_list() to display the full list of countries
# For the example Chile is "chl" and China is "chn"

# What does Chile export to China?
# Years 2010-2015 (HS92 4 characters)
# treemap_interval("chl", "chn", "exports", 2010, 2015)
# treemap_interval("chl", "chn", "exports", 2010, 2015, 1, 1, 1) # equivalent to last command
}
\keyword{functions}
