% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds.fv.R
\name{odds.fv}
\alias{odds.fv}
\title{Calculate the fair (vigorish free) odds for a vector of vigged odds.}
\usage{
odds.fv(..., input = "us", output = "us",
  Vectorized2wayOutput1stElement = FALSE)
}
\arguments{
\item{...}{Odds of the format defined in input, the odds can be submitted as a data.frame or as a vector}

\item{input}{Default to US Odds. Valid selections are  "us" for US odds,
"prob" for Probability ,"dec" for Decimal odds,"malay" for Malaysian odds,
"hk" for Hong Kong odds, "indo" for Indonesian odds}

\item{output}{Default to US Odds. Valid selections are  "us" for US odds,
"prob" for Probability ,"dec" for Decimal odds,"malay" for Malaysian odds,
"hk" for Hong Kong odds, "indo" for Indonesian odds}

\item{Vectorized2wayOutput1stElement}{This speeds up the calculation as the output is a a vector that contains the FV of the first input. Usefull in dplyr chains}
}
\value{
A vector or a matrix of the fair values of the the given vigged values in the format chosen in output
}
\description{
Calculate the fair (vigorish free) odds for a vector of vigged odds.
}
\examples{
odds.fv(-120,110)
odds.fv(2.05,3.12,2.90,input="dec",output="prob")
df <- data.frame(Home = c(1.5,1.8,1.9),
                Away = c(2.9,2.2,2.05))
odds.fv(df,input = "dec",output = "prob")
odds.fv(df$Home,df$Away,input="dec",output="prob")
odds.fv(df$Home,df$Away,input="dec",output="prob",Vectorized2wayOutput1stElement = TRUE)
}

