% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.nortek.ad2cp.R
\name{adpAd2cpFileTrim}
\alias{adpAd2cpFileTrim}
\title{Trim an AD2CP File}
\usage{
adpAd2cpFileTrim(infile, n = 100L, outfile, debug = getOption("oceDebug"))
}
\arguments{
\item{infile}{name of an AD2CP file.}

\item{n}{integer indicating the number of data chunks to keep. The default is
to keep 100 chunks, a common choice for sample files.}

\item{outfile}{optional name of the new AD2CP file to be created. If this is not
supplied, a default is used, by adding \verb{_trimmed} to the base filename, e.g.
if \code{infile} is \code{"a.ad2cp"} then \code{outfile} will be \code{a_trimmed.ad2cp}.}

\item{debug}{an integer value indicating the level of debugging. If
this is 1L, then a brief indication is given of the processing steps. If it
is > 1L, then information is given about each data chunk, which can yield
very extensive output.}
}
\value{
\code{adpAd2cpFileTrim()} returns the name of the output file, \code{outfile}, as
provided or constructed.
}
\description{
Create an AD2CP file by copying the first \code{n} data chunks (regions starting
with \code{0xa5}, etc) of another such file. This can be useful in supplying
small sample files for bug reports.
}
\section{Sample of Usage}{

\preformatted{
# Can only be run by the developer, since it uses a private file.
f  <- "~/Dropbox/oce_secret_data/ad2cp/byg_trimmed.ad2cp"
if (file.exists(f))
    adpAd2cpFileTrim(f, 100L) # this file is already trimmed to 200 chunks
}
}

\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}

Other things related to ad2cp data: 
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{is.ad2cp}()},
\code{\link{read.adp.ad2cp}()}

Other functions that trim data files: 
\code{\link{adpRdiFileTrim}()},
\code{\link{advSontekAdrFileTrim}()},
\code{\link{oceFileTrim}()}
}
\author{
Dan Kelley
}
\concept{functions that trim data files}
\concept{things related to ad2cp data}
\concept{things related to adp data}
