% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odf.R
\name{read.ctd.odf}
\alias{read.ctd.odf}
\title{Read a CTD file in ODF format}
\usage{
read.ctd.odf(
  file,
  columns = NULL,
  station = NULL,
  missingValue,
  deploymentType = "unknown",
  monitor = FALSE,
  exclude = NULL,
  debug = getOption("oceDebug"),
  processingLog,
  ...
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.  For \code{\link[=read.ctd.sbe]{read.ctd.sbe()}} and \code{\link[=read.ctd.woce]{read.ctd.woce()}}, this may be a
wildcard (e.g. \code{"*.cnv"} or \code{"*.csv"}) in which case the return
value is a vector containing CTD objects created by reading the files from
\code{\link[=list.files]{list.files()}} with \code{pattern} set to the specified wildcard
pattern.}

\item{columns}{an optional \link{list} that can be used to convert unrecognized
data names to resultant variable names.  This is used only by
\code{\link[=read.ctd.sbe]{read.ctd.sbe()}} and \code{\link[=read.ctd.odf]{read.ctd.odf()}}. For example,
if a data file named salinity as \code{"SAL"}, then using\preformatted{d <- read.ctd(f, columns=list(
    salinity=list(name="SAL",
                  unit=list(unit=expression(),
                  scale="PSS-78"))))
}

would assign the \code{"SAL"} column to the \code{salinity} entry in the data
slot of the CTD object returned by the \verb{read.*} function.}

\item{station}{optional character string containing an identifying name or
number for the station. This can be useful if the routine cannot determine the
name automatically, or if another name is preferred.}

\item{missingValue}{optional missing-value flag; data matching this value will
be set to \code{NA} upon reading. If this is provided, then it overrules any
missing-value flag found in the data. For Seabird (\code{.cnv}) files, there is
usually no need to set \code{missingValue}, because it can be inferred from the
header (typically as -9.990e-29). Set \code{missingValue=NULL} to turn off
missing-value detection, even in \code{.cnv} files that contain missing-value
codes in their headers. If \code{missingValue} is not specified,
then an attempt is made to infer such a value from the data, by testing
whether salinity and/or temperature has a minimum that is under -8 in value;
this should catch common values in files, without false positives. A warning
will be issued in this case, and a note inserted in the processing log of
the return value.}

\item{deploymentType}{character string indicating the type of deployment. Use
\code{"unknown"} if this is not known, \code{"profile"} for a profile (in
which the data were acquired during a downcast, while the device was lowered
into the water column, perhaps also including an upcast; \code{"moored"} if
the device is installed on a fixed mooring, \code{"thermosalinograph"} (or
\code{"tsg"}) if the device is mounted on a moving vessel, to record
near-surface properties, or \code{"towyo"} if the device is repeatedly
lowered and raised.}

\item{monitor}{boolean, set to \code{TRUE} to provide an indication of
progress.  This is useful if \code{filename} is a wildcard.}

\item{exclude}{either a character value holding a regular
expression that is used with \code{\link[=grep]{grep()}} to remove lines from the
header before processing, or \code{NULL} (the default), meaning
not to exclude any such lines.  The purpose of this argument
is to solve problems with some files, which can have
thousands of lines that indicate details that are may be of
little value in processing.  For example, some files have thousands
of lines that would be excluded by using
\code{exclude="PROCESS='Nulled the .* value"} in the function call.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}

\item{processingLog}{if provided, the action item to be stored in the log.
This is typically only provided for internal calls; the default that it provides is
better for normal calls by a user.}

\item{...}{additional arguments, passed to called routines.}
}
\value{
a \linkS4class{ctd} object. The details of the contents
depend on the source file. The \code{metadata} slot is particularly
variable across data formats, because the meta-information provided
in those formats varies so widely.
}
\description{
Read a CTD file in ODF format
}
\details{
\code{read.ctd.odf} reads files stored in Ocean Data Format, used in
some Canadian hydrographic databases.
}
\section{Caution}{


Lacking detailed documentation of the ODF file format, the \code{\link[=read.odf]{read.odf()}} and
\code{\link[=read.ctd.odf]{read.ctd.odf()}} functions were crafted based on inspection of data files, and
so some guesses had to be made.

The \code{PARAMETER_HEADER} chunks describing quality-control flags are
a case in point.  These contain \code{NAME} components that
refer to other \code{PARAMETER_HEADER} chunks that hold measured data.  However,
those references are not always matched well with the data names, and
even if they do match, the cross-reference syntax used by
the Bedford Institute of Oceanography differs from that used by
l’Institut Maurice-Lamontagne. To simplify coding, it was assumed that
each quality-control sequence applies to the data sequence
immediately preceding it.  (This assumption is made in other
analysis systems.)

It is also prudent to pay attention to the units decoding,
which \code{\link[=read.odf]{read.odf()}} handles by calling \code{\link[=unitFromString]{unitFromString()}}.
Be on the lookout for incorrect temperature scales, which
are sometimes reported with nonstandard strings in ODF files.
Also, note that you may see warnings about conductivity ratios,
which some ODF files incorrectly suggest have dimensions.
}

\references{
For sources that describe the ODF format, see the documentation
for the \linkS4class{odf} class.
}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}

Other things related to odf data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{ODF2oce}()},
\code{\link{ODFListFromHeader}()},
\code{\link{ODFNames2oceNames}()},
\code{\link{[[,odf-method}},
\code{\link{[[<-,odf-method}},
\code{\link{odf-class}},
\code{\link{plot,odf-method}},
\code{\link{read.odf}()},
\code{\link{subset,odf-method}},
\code{\link{summary,odf-method}}

Other functions that read ctd data: 
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()}
}
\author{
Dan Kelley
}
\concept{functions that read ctd data}
\concept{things related to ctd data}
\concept{things related to odf data}
