% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{subtractBottomVelocity}
\alias{subtractBottomVelocity}
\title{Subtract Bottom Velocity from ADP}
\usage{
subtractBottomVelocity(x, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an object of class \code{"adp"}, which contains bottom tracking
velocities.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Subtracts bottom tracking velocities from an \code{"adp"} object. Works for
all coordinate systems (\code{beam}, \code{xyz}, and \code{enu}).
}
\seealso{
See \code{\link{read.adp}} for notes on functions relating to
\code{"adp"} objects, and \code{\link{adp-class}} for notes on the ADP
object class.
}
\author{
Dan Kelley and Clark Richards
}
