% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobo.R
\docType{data}
\name{lobo}
\alias{lobo}
\title{LOBO Dataset}
\source{
The data were downloaded from a web interface at Satlantic LOBO web
server and then read with \code{\link{read.lobo}}.
}
\description{
This is sample lobo dataset obtained in the Northwest Arm of Halifax by
Satlantic.
}
\examples{
\donttest{
library(oce)
data(lobo)
summary(lobo)
plot(lobo)
}

}
\seealso{
Other datasets provided with oce: \code{\link{adp}},
  \code{\link{adv}}, \code{\link{argo}}, \code{\link{cm}},
  \code{\link{coastlineWorld}}, \code{\link{ctdRaw}},
  \code{\link{ctd}}, \code{\link{echosounder}},
  \code{\link{landsat}}, \code{\link{lisst}},
  \code{\link{met}}, \code{\link{ocecolors}},
  \code{\link{rsk}}, \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}}, \code{\link{section}},
  \code{\link{topoWorld}}, \code{\link{wind}}

Other things related to lobo data: \code{\link{[[,lobo-method}},
  \code{\link{[[<-,lobo-method}}, \code{\link{as.lobo}},
  \code{\link{lobo-class}}, \code{\link{plot,lobo-method}},
  \code{\link{read.lobo}},
  \code{\link{subset,lobo-method}},
  \code{\link{summary,lobo-method}}
}
\author{
Dan Kelley
}
\concept{datasets provided with oce}
\concept{things related to lobo data}
