% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{binApply2D}
\alias{binApply2D}
\title{Apply a function to matrix data}
\usage{
binApply2D(x, y, f, xbreaks, ybreaks, FUN, ...)
}
\arguments{
\item{x}{a vector of numerical values.}

\item{y}{a vector of numerical values.}

\item{f}{a vector of data to which the elements of \code{FUN} may be
supplied}

\item{xbreaks}{values of \code{x} at the boundaries between the
bins; calculated using \code{\link{pretty}} if not supplied.}

\item{ybreaks}{as \code{xbreaks}, but for \code{y}.}

\item{FUN}{univariate function that is applied to the \code{f} data within
any given bin}

\item{\dots}{arguments to pass to the function \code{FUN}}
}
\value{
A list with the following elements: the breaks in \code{x} and
\code{y} (i.e. \code{xbreaks} and \code{ybreaks}), the break mid-points
(i.e. \code{xmids} and \code{ymids}), and a matrix containing the
result of applying \code{FUN()} to the \code{f} values, as
subsetted by these breaks.
}
\description{
The function \code{FUN} is applied to \code{f} in bins specified by
\code{xbreaks} and \code{ybreaks}.  (If \code{FUN} is \code{\link{mean}},
consider using \code{\link{binMean2D}} instead, since it should be faster.)
}
\examples{
library(oce)
\donttest{
## secchi depths in lat and lon bins
if (require(ocedata)) {
    data(secchi, package="ocedata")
    ## Note that zlim is provided to the colormap(), to prevent a few
    ## points from setting a very wide scale.
    cm <- colormap(z=secchi$depth, col=oceColorsViridis, zlim=c(0, 15))
    par(mar=c(2, 2, 2, 2))
    drawPalette(colormap=cm, zlab="Secchi Depth")
    data(coastlineWorld)
    mapPlot(coastlineWorld, longitudelim=c(-5, 20), latitudelim=c(50, 66),
      grid=5, col='gray', projection="+proj=lcc +lat_1=50 +lat_2=65")
    bc <- binApply2D(secchi$longitude, secchi$latitude,
                     pretty(secchi$longitude, 80),
                     pretty(secchi$latitude, 40),
                     f=secchi$depth, FUN=mean)
    mapImage(bc$xmids, bc$ymids, bc$result, zlim=cm$zlim, col=cm$zcol)
    mapPolygon(coastlineWorld, col="gray")
}
}

}
\seealso{
Other bin-related functions: \code{\link{binApply1D}},
  \code{\link{binAverage}}, \code{\link{binCount1D}},
  \code{\link{binCount2D}}, \code{\link{binMean1D}},
  \code{\link{binMean2D}}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
