% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{oceSetData}
\alias{oceSetData}
\title{Set something in the \code{data} slot of an \code{oce} object}
\usage{
oceSetData(object, name, value, unit, originalName, note = "")
}
\arguments{
\item{object}{an \code{oce} object}

\item{name}{String indicating the name of the item to be set.}

\item{value}{Value for the item.}

\item{unit}{An optional indication of the units for the item. This has
three possible forms (see \dQuote{Details}).}

\item{originalName}{Optional character string giving an 'original' name (e.g.
as stored in the header of a data file).}

\item{note}{Either empty (the default), a character string, or \code{NULL},
to control additions made to the processing log of the return value. If
\code{note=""} then the an entry is created based on deparsing the function call.
If \code{note} is a non-empty string, then that string gets added added
to the processing log. Finally, if \code{note=NULL}, then nothing is
added to the processing log. This last form is useful in cases where
\code{oceSetData} is to be called many times in succession, resulting
in an overly verbose processing log; in such cases, it might help
to add a note by e.g. \code{processingLog(a) <- "QC (memo dek-2018-01/31)"}}
}
\description{
Set something in the \code{data} slot of an \code{oce} object
}
\details{
There are three possibilities for \code{unit}:
\itemize{
\item \emph{Case 1.} \code{unit} is a named or unnamed \code{\link{list}}
that contains two items.
If the list is named, the names must be
\code{unit} and \code{scale}. If the list is unnamed, the stated names are assigned
to the items, in the stated order. Either way, the \code{unit}
item must be an \code{\link{expression}} that specifies the unit,
and the \code{scale} item must be a string that describes the scale. For
example, modern temperatures have
\code{unit=list(unit=expression(degree*C), scale="ITS-90")}.
\item \emph{Case 2.} \code{unit} is an \code{\link{expression}} giving the unit as above. In this
case, the scale will be set to \code{""}.
\item \emph{Case 3.} \code{unit} is a character string that is converted
into an expression with \code{\link{parse}(text=unit)},
and the scale set to \code{""}.
}
}
\examples{
data(ctd)
Tf <- swTFreeze(ctd)
ctd <- oceSetData(ctd, "freezing", Tf, list(unit=expression(degree*C), scale="ITS-90"))
feet <- swDepth(ctd) / 0.3048
ctd <- oceSetData(ctd, name="depthInFeet", value=feet, expression("feet"))
fathoms <- feet / 6
ctd <- oceSetData(ctd, "depthInFathoms", fathoms, "fathoms")
}
