% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swLapseRate}
\alias{swLapseRate}
\title{Seawater lapse rate}
\usage{
swLapseRate(salinity, temperature = NULL, pressure = NULL,
  longitude = NULL, latitude = NULL, eos = getOption("oceEOS", default =
  "gsw"))
}
\arguments{
\item{salinity}{either salinity [PSU] (in which case \code{temperature} and
\code{pressure} must be provided) \strong{or} a \code{ctd} object (in which
case \code{salinity}, \code{temperature} and \code{pressure} are determined
from the object, and must not be provided in the argument list).}

\item{temperature}{\emph{in-situ} temperature [\eqn{^\circ}{deg}C], defined
on the ITS-90 scale; see \dQuote{Temperature units} in the documentation for
\code{\link{swRho}}.}

\item{pressure}{pressure [dbar]}

\item{longitude}{longitude of observation (only used if \code{eos="gsw"};
see \sQuote{Details}).}

\item{latitude}{latitude of observation (only used if \code{eos="gsw"}; see
\sQuote{Details}).}

\item{eos}{equation of state, either \code{"unesco"} [1,2] or \code{"gsw"}
[3,4].}
}
\value{
Lapse rate [\eqn{deg}{deg}C/m].
}
\description{
Compute adiabatic lapse rate
}
\details{
If \code{eos="unesco"}, the density is calculated using the UNESCO equation
of state for seawater [1,2], and if \code{eos="gsw"}, the GSW formulation
[3,4] is used.
}
\examples{
lr <- swLapseRate(40, 40, 10000) # 3.255976e-4

}
\references{
Fofonoff, P. and R. C. Millard Jr, 1983. Algorithms for
computation of fundamental properties of seawater. \emph{Unesco Technical
Papers in Marine Science}, \bold{44}, 53 pp.  (Section 7, pages 38-40)
}
\seealso{
Other functions that calculate seawater properties: \code{\link{T68fromT90}},
  \code{\link{T90fromT48}}, \code{\link{T90fromT68}},
  \code{\link{swAbsoluteSalinity}},
  \code{\link{swAlphaOverBeta}}, \code{\link{swAlpha}},
  \code{\link{swBeta}}, \code{\link{swCSTp}},
  \code{\link{swConservativeTemperature}},
  \code{\link{swDepth}}, \code{\link{swDynamicHeight}},
  \code{\link{swN2}}, \code{\link{swPressure}},
  \code{\link{swRho}}, \code{\link{swRrho}},
  \code{\link{swSCTp}}, \code{\link{swSTrho}},
  \code{\link{swSigma0}}, \code{\link{swSigma1}},
  \code{\link{swSigma2}}, \code{\link{swSigma3}},
  \code{\link{swSigma4}}, \code{\link{swSigmaTheta}},
  \code{\link{swSigmaT}}, \code{\link{swSigma}},
  \code{\link{swSoundAbsorption}},
  \code{\link{swSoundSpeed}}, \code{\link{swSpecificHeat}},
  \code{\link{swSpice}}, \code{\link{swTFreeze}},
  \code{\link{swTSrho}},
  \code{\link{swThermalConductivity}},
  \code{\link{swTheta}}, \code{\link{swViscosity}},
  \code{\link{swZ}}
}
\author{
Dan Kelley
}
