% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{binCount2D}
\alias{binCount2D}
\title{Bin-count matrix data}
\usage{
binCount2D(x, y, xbreaks, ybreaks, flatten = FALSE)
}
\arguments{
\item{x}{Vector of numerical values.}

\item{y}{Vector of numerical values.}

\item{xbreaks}{Vector of values of \code{x} at the boundaries between bins, calculated using
\code{\link{pretty}(x)} if not supplied.}

\item{ybreaks}{Vector of values of \code{y} at the boundaries between bins, calculated using
\code{\link{pretty}(y)} if not supplied.}

\item{flatten}{A logical value indicating whether
the return value also contains equilength
vectors \code{x}, \code{y}, \code{z} and \code{n}, a flattened
representation of \code{xmids}, \code{ymids}, \code{result} and
\code{number}.}
}
\value{
A list with the following elements: the breaks (\code{xbreaks}
and \code{ybreaks}), the midpoints (\code{xmids} and \code{ymids})
between those breaks, and
the count (\code{number}) of \code{f} values in the boxes defined
between successive breaks.
}
\description{
Count the number of elements of a given matrix z=z(x,y) that fall within
successive pairs of breaks in x and y.
}
\seealso{
Other bin-related functions: \code{\link{binApply1D}},
  \code{\link{binApply2D}}, \code{\link{binAverage}},
  \code{\link{binCount1D}}, \code{\link{binMean1D}},
  \code{\link{binMean2D}}
}
\author{
Dan Kelley
}
