% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\docType{class}
\name{adv-class}
\alias{adv-class}
\title{Class to Hold adv Data}
\description{
This class holds data from acoustic-Dopper velocimeters.
}
\details{
The \code{metadata} slot
    contains various items relating to the dataset, including source file name,
    sampling rate, velocity resolution and scale, etc.  The
    \code{processingLog} is in standard form and needs little comment.  The
    \code{data} slot holds a numeric matrix \code{v} of velocities in m/s, with
    the first index indicating time and the second indicating beam number.  The
    meanings of the beams depends on whether the object is in beam
    coordinates, frame coordinates, or earth coordinates.  The \code{data} slot
    also contains identically-dimensioned raw matrices \code{a} and \code{q},
    holding measures of signal strength and data quality quality, respectively.
    It also contains a series of vectors, e.g. \code{time}, \code{temperature}
    and \code{pressure}, etc., depending on what sensors are included in the
    package.  For all of these quantities, the details can be different for
    different instrument types, and it is assumed that the user will be
    familiar with the details.

Data may be extracted with \code{\link{[[,adv-method}} and inserted
with \code{\link{[[<-,adv-method}}. Type \code{?"[[,adv-method"}
or \code{?"[[<-,adv-method"} to learn more.
}
\examples{
data(adv)
adv[["v"]] <- 0.001 + adv[["v"]] # add 1mm/s to all velocity components

}
\seealso{
A file containing ADV data is usually recognized by Oce, and so
    \code{\link{read.oce}} will usually read the data.  If not, one may use the
    general ADV function \code{\link{read.adv}} or specialized variants
    \code{\link{read.adv.nortek}}, \code{\link{read.adv.sontek.adr}} or
    \code{\link{read.adv.sontek.text}}.

    ADV data may be plotted with \code{\link{plot,adv-method}} function, which is a
    generic function so it may be called simply as \code{plot(x)}, where
    \code{x} is an object inheriting from \code{\link{adv-class}}.

    Statistical summaries of ADV data are provided by the generic function
    \code{\link{summary,adv-method}}.

    Conversion from beam to xyz coordinates may be done with
    \code{\link{beamToXyzAdv}}, and from xyz to enu (east north up) may be done
    with \code{\link{xyzToEnuAdv}}.  \code{\link{toEnuAdv}} may be used to
    transfer either beam or xyz to enu.  Enu may be converted to other
    coordinates (e.g. aligned with a coastline) with
    \code{\link{enuToOtherAdv}}.

Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{argo-class}}, \code{\link{bremen-class}},
  \code{\link{cm-class}}, \code{\link{coastline-class}},
  \code{\link{ctd-class}}, \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{rsk-class}},
  \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{adv} data: \code{\link{[[,adv-method}},
  \code{\link{[[<-,adv-method}}, \code{\link{adv}},
  \code{\link{beamName}}, \code{\link{beamToXyz}},
  \code{\link{enuToOtherAdv}}, \code{\link{enuToOther}},
  \code{\link{plot,adv-method}},
  \code{\link{read.adv.nortek}},
  \code{\link{read.adv.sontek.adr}},
  \code{\link{read.adv.sontek.serial}},
  \code{\link{read.adv.sontek.text}},
  \code{\link{read.adv}}, \code{\link{subset,adv-method}},
  \code{\link{summary,adv-method}}, \code{\link{toEnuAdv}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdv}}, \code{\link{xyzToEnu}}
}
