% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{auxco}
\alias{auxco}
\title{German Auxiliary Classification of Occupations (AuxCO)}
\format{
A list with data.tables:
\describe{
\item{\code{categories}}{data.table. Main list of AuxCO categories including their descriptions etc.}
\item{\code{distinctions}}{data.table. List of highly similar AuxCO categories that one may want to present to disambiguate between them.}
\item{\code{followup_questions}}{data.table. Follow-up questions to specify final codings based on AuxCO categories. Includes the questions' answer options as well as information on how to encode more complex occupations which depend on multiple answers.}
\item{\code{mapping_from_isco}}{data.table. Mapping from ISCO-08 categories to AuxCO categories.}
\item{\code{mapping_from_kldb}}{data.table. Mapping from KldB 2010 categories to AuxCO categories.}
}
}
\usage{
auxco
}
\description{
Berufs-Hilfsklassifikation mit Tätigkeitsbeschreibungen.
}
\references{
Schierholz, Malte; Brenner, Lorraine; Cohausz, Lea; Damminger, Lisa; Fast, Lisa; Hörig, Ann-Kathrin; Huber, Anna-Lena; Ludwig, Theresa; Petry, Annabell; Tschischka, Laura (2018): Vorstellung einer Hilfsklassifikation mit Tätigkeitsbeschreibungen für Zwecke der Berufskodierung. (IAB-Discussion Paper, 2018), Nürnberg, 45 S. https://www.iab.de/183/section.aspx/Publikation/k180509301
}
\seealso{
https://github.com/occupationMeasurement/auxiliary-classification, \code{\link[=load_auxco]{load_auxco()}}
}
\keyword{datasets}
