% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{.coords2country}
\alias{.coords2country}
\title{Extracts country ISO3 based on locations}
\usage{
.coords2country(
  xydat,
  .countries.shapefile = NULL,
  .points.proj4string = NULL,
  ctryNameField = NULL,
  verbose = FALSE
)
}
\arguments{
\item{xydat}{A dataframe with x and y coordinates}

\item{.countries.shapefile}{SpatialPolygonsDataFrame of world countries and their associated ISO3 codes}

\item{.points.proj4string}{Proj4string for the occurrence data}

\item{ctryNameField}{character. Column name in .countries shapefile where ISO3 are indicated}

\item{verbose}{logical. Print messages?}
}
\value{
Factor with ISO3 codes for countries
}
\description{
Extracts country ISO3 based on locations
}
\seealso{
Other Geo: 
\code{\link{.getSRTM}()}
}
\author{
Josep M Serra Diaz
}
\concept{Geo}
