% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voxel_selection.R
\name{voxel_selection}
\alias{voxel_selection}
\alias{voxel_selection_with_erosion}
\title{Voxel Selection Procedure}
\usage{
voxel_selection(flair, brain_mask, cutoff)

voxel_selection_with_erosion(flair, brain_mask, verbose = TRUE,
  eroder = c("fsl", "oasis"))
}
\arguments{
\item{flair}{FLAIR volume of class \code{\link{nifti}}}

\item{brain_mask}{brain mask of class \code{\link{nifti}}}

\item{cutoff}{the percentile cutoff for the thresholding,
passed to \code{\link{quantile}}}

\item{verbose}{print diagnostic output}

\item{eroder}{Should \code{\link{fslerode}} or \code{\link{oasis_erode}} 
be used}
}
\value{
Returns the voxel selection mask as an object of class \code{\link{nifti}}.
}
\description{
This function creates a binary mask for the voxel selection
procedure for OASIS.
}
\examples{
library(neurobase)
library(fslr)
library(oasis)
niis = tempfile(fileext = ".nii.gz")
if (require(httr)) {
   url = paste0("https://s3.us-east-2.amazonaws.com/brainder/software/",
   "flair/templates/GG-853-FLAIR-2.0mm.nii.gz")
   req <- httr::GET(url,
   httr::write_disk(path = niis))
   httr::stop_for_status(req)

 flair <- readnii(niis)
 if (have.fsl()) {
   brain_mask = fslbet(niis) > 0
 } else {
   ind = list(c(10L, 81L), c(12L, 101L), c(3L, 78L))
   all.ind = lapply(ind, function(x) seq(x[1], x[2]))
   brain_mask = niftiarr(flair, 0)
   eg = expand.grid(all.ind)
   eg = as.matrix(eg)
   brain_mask[eg] = 1
 }
 voxel_selection_mask <- voxel_selection(flair,
   brain_mask, cutoff = .85)
}
}
