% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/height.R
\name{height}
\alias{height}
\alias{height.rtree}
\alias{height<-}
\title{Height of a tree}
\usage{
height(.tree)

\method{height}{rtree}(.tree)

height(x) <- value
}
\arguments{
\item{.tree, x}{A tree.}

\item{value}{integer. Height to assign to the tree \code{x} 
(this calls the function \code{\link[oak]{prune}}).}
}
\value{
An integer.
}
\description{
This function returns the height of a tree, 
defined as the number of nodes of the longest subchain. 
For an empty tree, the height is conventionally equal to 0.
}
\examples{
## Rooted tree
(tr0 = c_("Bob", "Carl", "Daniel"))
tr1 = r_("Dimitri", s = list(c_("Enoc"), c_("Ferdinand")))
tr1 = r_("Caroline", s = list(tr1))
(tr1 = r_("Bill", s = list(tr1)))
(tr2 = r_("Alice", s = list(tr0, tr1)))
height(empty_tree())
height(tr0)
height(tr1)
height(tr2)

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
height(tr3)

}
