% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_homeless_drop_in_centers.R
\name{nyc_homeless_drop_in_centers}
\alias{nyc_homeless_drop_in_centers}
\title{NYC Homeless Drop- In Centers}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Social-Services/Directory-Of-Homeless-Drop-In-Centers/bmxf-3rd4/about_data>
}
\usage{
nyc_homeless_drop_in_centers(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Directory Of Homeless Drop- In Centers data.
}
\description{
Directory Of Homeless Drop- In Centers
}
\details{
List of centers where homeless people are provided with hot meals, showers, medical help and a place to sleep
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 10 rows)
  small_sample <- nyc_homeless_drop_in_centers(limit = 10)
  head(small_sample)

  nyc_homeless_drop_in_centers(limit = 5000)
  nyc_homeless_drop_in_centers(filters = list(borough = "Bronx"))
}
}
}
